/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AGW_WIND_RADII_AREA header file.
 *
 ******************************************************************************/

#ifndef AGW_WIND_RADII_AREA_OBJ_H_
#define AGW_WIND_RADII_AREA_OBJ_H_

#include "sms_api.h"
#include "agw_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct agw_wind_radii_area_data_struct
{
    // Sequence ID
    UN16 un16SequenceID;

    // Wind speed
    AGW_FIXED_OBJECT_STRUCT sWindSpeed;
} AGW_WIND_RADII_AREA_DATA_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

AGW_WIND_RADII_AREA_OBJECT AGW_WIND_RADII_AREA_hCreate(
    SMS_OBJECT hParent,
    AGW_PRODUCT_HEADER_STRUCT *psHeader
        );

BOOLEAN AGW_WIND_RADII_AREA_bUpdate(
    AGW_WIND_RADII_AREA_OBJECT hAgwWindRd,
    AGW_WIND_RADII_AREA_DATA_STRUCT *psWindRdData
        );

void AGW_WIND_RADII_AREA_vDestroy(
    AGW_WIND_RADII_AREA_OBJECT hAgwShape
        );

#endif /* AGW_WIND_RADII_AREA_OBJ_H_ */
