/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AGW_STORM_POSITION header file.
 *
 ******************************************************************************/

#ifndef AGW_STORM_POSITION_OBJ_H_
#define AGW_STORM_POSITION_OBJ_H_

#include "sms_api.h"
#include "agw_storm_obj.h"
#include "agw_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct agw_storm_position_data_struct
{
    // Sequence ID used to find related wind radii area
    UN16 un16SequenceID;

    // Position type
    AGW_STORM_POSITION_TYPE_ENUM ePositionType;

    // Storm movement speed
    AGW_FIXED_OBJECT_STRUCT sSpeed;
    BOOLEAN bSpeedAvailable;

    // Storm travel direction
    AGW_FIXED_OBJECT_STRUCT sDirection;
    BOOLEAN bDirectionAvailable;

    // Storm max sustained winds speed
    AGW_FIXED_OBJECT_STRUCT sMaxWinds;

    // Storm gusts speed
    AGW_FIXED_OBJECT_STRUCT sGusts;

    // Storm pressure
    AGW_FIXED_OBJECT_STRUCT sPressure;

    // Time
    TIME_T tTimeStamp;

    // Storm type
    AGW_STORM_TYPE_ENUM eStormType;
} AGW_STORM_POSITION_DATA_STRUCT;

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

AGW_STORM_POSITION_OBJECT AGW_STORM_POSITION_hCreate(
    SMS_OBJECT hParent,
    size_t tDescriptorSize,
    AGW_PRODUCT_HEADER_STRUCT *psHeader
        );

BOOLEAN AGW_STORM_POSITION_bUpdate(
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    AGW_STORM_POSITION_DATA_STRUCT *psStormPosData
        );

AGW_RETURN_CODE_ENUM AGW_STORM_POSITION_eAttachStorm(
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    AGW_STORM_OBJECT hStorm
        );

AGW_RETURN_CODE_ENUM AGW_STORM_POSITION_eAppendWindRadii(
    AGW_STORM_POSITION_OBJECT hAgwStormPos,
    AGW_WIND_RADII_AREA_OBJECT hWindRadii
        );

void AGW_STORM_POSITION_vDestroy(
    AGW_STORM_POSITION_OBJECT hAgwStormPos
        );

#endif /* AGW_STORM_POSITION_OBJ_H_ */

