/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AGW_STORM header file.
 *
 ******************************************************************************/

#ifndef AGW_STORM_OBJ_H_
#define AGW_STORM_OBJ_H_

#include "sms_api.h"
#include "agw_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef struct agw_storm_object *AGW_STORM_OBJECT;
#define AGW_STORM_INVALID_OBJECT ((AGW_STORM_OBJECT)NULL)

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

AGW_STORM_OBJECT AGW_STORM_hCreate(
    SMS_OBJECT hParent,
    STRING_OBJECT *phID,
    STRING_OBJECT *phName
        );

void AGW_STORM_vDestroy(
    AGW_STORM_OBJECT hObj
        );

AGW_RETURN_CODE_ENUM AGW_STORM_eAddPosition(
    AGW_STORM_OBJECT hObj,
    AGW_STORM_POSITION_OBJECT hStormPositionObject
        );

AGW_RETURN_CODE_ENUM AGW_STORM_eIteratePositions(
    AGW_STORM_OBJECT hObj,
    AGW_SHAPE_CALLBACK bCallback,
    void *pvCallbackArgv
        );

BOOLEAN AGW_STORM_bCompareByID(
    AGW_STORM_OBJECT hObj,
    STRING_OBJECT hID
        );

STRING_OBJECT AGW_STORM_hName(
    AGW_STORM_OBJECT hObj
        );

STRING_OBJECT AGW_STORM_hID(
    AGW_STORM_OBJECT hObj
        );

#endif /* AGW_STORM_POSITION_OBJ_H_ */
