/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:AGW_SHAPE header file.
 *
 ******************************************************************************/

#ifndef AGW_SHAPE_OBJ_H_
#define AGW_SHAPE_OBJ_H_

#include "sms_api.h"
#include "agw_mgr_obj.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Declares callback interface
typedef struct agw_shape_callback_interface_struct
{
    // Checks intersection between shape and the location
    AGW_RETURN_CODE_ENUM (*eHasIntersection) (
        AGW_SHAPE_OBJECT hShape,
        const AGW_LOCATION_DESC_STRUCT *psLocDesc
            );

} AGW_SHAPE_CALLBACK_INTERFACE_STRUCT;

// Declares callback for lines iteration
typedef BOOLEAN (*AGW_SHAPE_LINES_ITERATOR_CALLBACK) (
    OSAL_FIXED_OBJECT hLatBegin,
    OSAL_FIXED_OBJECT hLonBegin,
    OSAL_FIXED_OBJECT hLatEnd,
    OSAL_FIXED_OBJECT hLonEnd,
    void *pvArg
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

AGW_SHAPE_OBJECT AGW_SHAPE_hCreate(
    void **ppvData,
    const char *pacName,
    AGW_PRODUCT_HEADER_STRUCT *psHeader,
    AGW_SHAPE_TYPE_ENUM eShapeType,
    size_t tSize,
    size_t tDescriptorSize,
    SMS_OBJECT hParent
        );

void AGW_SHAPE_vDestroy(
    AGW_SHAPE_OBJECT hAgwShape
        );

AGW_RETURN_CODE_ENUM AGW_SHAPE_eHasIntersectionWith (
    AGW_SHAPE_OBJECT hAgwShape,
    const AGW_LOCATION_DESC_STRUCT *psLocDesc
        );

AGW_RETURN_CODE_ENUM AGW_SHAPE_eHasDirectIntersectionWith (
    AGW_SHAPE_OBJECT hAgwShape,
    const AGW_LOCATION_DESC_STRUCT *psLocDesc
        );

AGW_RETURN_CODE_ENUM AGW_SHAPE_eIterateLines (
    AGW_SHAPE_OBJECT hShape,
    SHAPE_LINES_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
        );

BOOLEAN AGW_SHAPE_bSetPoint(
    AGW_SHAPE_OBJECT hAgwShape,
    UN16 un16Index,
    N32 n32Lat,
    N32 n32Lon,
    UN8 un8PowOfDivider
        );

BOOLEAN AGW_SHAPE_bUpdatePoints(
    AGW_SHAPE_OBJECT hAgwShape,
    UN16 un16Points
        );

BOOLEAN AGW_SHAPE_bSetInterface(
    AGW_SHAPE_OBJECT hShape,
    const AGW_SHAPE_CALLBACK_INTERFACE_STRUCT *psIntf
        );

AGW_RETURN_CODE_ENUM AGW_SHAPE_eData(
    AGW_SHAPE_OBJECT hAgwShape,
    AGW_SHAPE_TYPE_ENUM eType,
    void **ppvData
        );

AGW_RETURN_CODE_ENUM AGW_SHAPE_ePopulateFixedValue(
    AGW_FIXED_OBJECT_STRUCT *psSrc,
    OSAL_FIXED_OBJECT hFixedDesc,
    BOOLEAN bTrigger
        );

#endif /* AGW_SHAPE_OBJ_H_ */
