/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _WEATHER_MSG_OBJ_H_
#define _WEATHER_MSG_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define WEATHER_MSG_OBJECT_NAME "WEATHER_MSG"


  /**************/
 /** TYPEDEFS **/
/**************/

typedef union weather_msg_data_union
{
	FORECAST_OBJECT ahForecasts[WEATHER_FORECAST_TYPE_MAX];
	SKI_CONDITIONS_OBJECT hSkiCond;
} WEATHER_MSG_DATA_UNION;

// Private object structure
typedef struct weather_msg_object_struct
{
	WEATHER_MSG_DATA_UNION uData;
	LOCATION_OBJECT hLocation;
	STRING_OBJECT hICAO;
	WEATHER_MSG_OBJECT_TYPE_ENUM eType;
} WEATHER_MSG_OBJECT_STRUCT;


/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eGetForecast (
    WEATHER_MSG_OBJECT hWeatherMsg,
    WEATHER_FORECAST_TYPE_ENUM eForecastType,
    FORECAST_OBJECT *phForecast
        );

static LOCATION_OBJECT hLocation (
    WEATHER_MSG_OBJECT hWeatherMsg
        );

static SMSAPI_RETURN_CODE_ENUM eGetSkiConditions (
    WEATHER_MSG_OBJECT hWeatherMsg,
    SKI_CONDITIONS_OBJECT *phSkiCond
        );

static WEATHER_MSG_OBJECT_TYPE_ENUM eType (
    WEATHER_MSG_OBJECT hWeatherMsg
        );

static N32 n32FPrintf (
    WEATHER_MSG_OBJECT hWeatherMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static STRING_OBJECT hICAO (
	WEATHER_MSG_OBJECT hWeatherMsg
		);

//Private prototypes
static void vDestroyObject(WEATHER_MSG_OBJECT_STRUCT *psObj);

static const char *pacGetForecastTypeName(
    WEATHER_FORECAST_TYPE_ENUM eType
        );

// Global (re-usable) instance of an interface for this object
const WEATHER_MSG_OBJECT_INTERFACE_STRUCT WEATHER_MSG =
{
	/*.eGetForecast = */eGetForecast,
	/*.hLocation = */hLocation,
	/*.eGetSkiConditions = */eGetSkiConditions,
	/*.eType = */eType,
	/*.hICAO = */hICAO,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _WEATHER_MSG_OBJ_H_
