/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _WEATHER_EVENT_OBJ_H_
#define _WEATHER_EVENT_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define WEATHER_EVENT_OBJECT_NAME "WEATHER_EVENT"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct weather_event_object_struct
{
	BOOLEAN bAvailable;
	WEATHER_EVENT_DATA_STRUCT sData;
} WEATHER_EVENT_OBJECT_STRUCT;


/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eCode (
	WEATHER_EVENT_OBJECT hWeatherEvent,
	WEATHER_EVENT_CODE_ENUM *peEventCode
		);

static STRING_OBJECT hDescription (
	WEATHER_EVENT_OBJECT hWeatherEvent
		);

static SMSAPI_RETURN_CODE_ENUM eIconCode (
	WEATHER_EVENT_OBJECT hWeatherEvent,
	UN8 *pun8EventIconCode
		);

static N32 n32FPrintf (
	WEATHER_EVENT_OBJECT hWeatherEvent,
	FILE *psFile
		);

/* Object Private Prototypes */

// Global (re-usable) instance of an interface for this object
const WEATHER_EVENT_OBJECT_INTERFACE_STRUCT WEATHER_EVENT =
{
	/*.eCode = */eCode,
	/*.hDescription = */hDescription,
	/*.eIconCode = */eIconCode,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/
#endif    // _WEATHER_EVENT_OBJ_H_
