/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _UVINFO_OBJ_H_
#define _UVINFO_OBJ_H_


  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define UVINFO_OBJECT_NAME "UVINFO"


  /**************/
 /** TYPEDEFS **/
/**************/


// Private object structure
typedef struct uvinfo_object_struct
{
	BOOLEAN bAvailable;
	UV_INFO_DATA_STRUCT sData;
} UVINFO_OBJECT_STRUCT;


/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eIndexRange (
	UVINFO_OBJECT hUVInfo,
	UN8 *pun8UVIndexRangeLow,
	UN8 *pun8UVIndexRangeHigh
		);

static SMSAPI_RETURN_CODE_ENUM eRiskRating (
	UVINFO_OBJECT hUVInfo,
	UV_RISK_ENUM *peUVRisk
		);

static N32 n32FPrintf (
	UVINFO_OBJECT hUVInfo,
	FILE *psFile
		);

/* Object Private Prototypes */

static const char *pacRisk (
    UV_RISK_ENUM eRisk
        );


// Global (re-usable) instance of an interface for this object
const UVINFO_OBJECT_INTERFACE_STRUCT UVINFO =
{
	/*.eIndexRange = */eIndexRange,
	/*.eRiskRating = */eRiskRating,
    /*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _UVINFO_OBJ_H_ */
