/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _TW_SEEK_H
#define _TW_SEEK_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

#include "tag_obj.h"
#include "seek.h"
#include "seek_content.h"
#include "tw_seek.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define TW_SEEK_OBJECT_NAME "TW_SEEK"

#define TW_SEEK_ENABLED                "Enabled"
#define TW_SEEK_CID                    "MarketCID"

#define TW_SEEK_MARKET_NAME_TEXT                "Market Name"
#define TW_SEEK_MARKET_ID_TEXT                  "Market Id"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct tw_seek_report_iterator_struct
{
    CID_OBJECT hCid;
    STRING_OBJECT *phMarketId;
    STRING_OBJECT *phMarketName;
	BOOLEAN bFound;
} TW_SEEK_REPORT_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eAvailableToRegister (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    SEEK_AVAILABILTY_ENUM *peTrafficWeatherAvailablility
        );

static SMSAPI_RETURN_CODE_ENUM eRegister (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eRegisterMarket (
    DECODER_OBJECT hDecoder,
    CID_OBJECT hReportId,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

/* Object Private Prototypes */

static BOOLEAN bSeekAlertAllowed(
    SEEK_SERVICE_OBJECT hSeek,
    CAL_CONTENT_OBJECT hContent
        );

static CD_OBJECT hGetCDOAndCids(
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    CID_OBJECT *phMarketCID
        );

static BOOLEAN bRetrieveCidsForSeeks(
    CD_OBJECT hCDO,
    CID_OBJECT *phMarketCID
        );

static BOOLEAN bHandleSeekAlert(
    SEEK_SERVICE_OBJECT hSeek,
    CAL_ALERT_OBJECT hAlert
        );

static BOOLEAN bInit(
    SEEK_SERVICE_OBJECT hSeek
        );

static BOOLEAN bAddToConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psItem,
    STRING_OBJECT hMarketIdString,
    STRING_OBJECT hMarketNameString
        );

static SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psRegisterContent(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    CID_OBJECT hMarketCID,
    STRING_OBJECT hMarketIdString,
    STRING_OBJECT hMarketNameString,
    SMSAPI_RETURN_CODE_ENUM *peReturn,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static BOOLEAN bRegisterContentFromConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRegisteredContentTagIterator(
    TAG_OBJECT hTag,
    SEEK_SERVICE_OBJECT_STRUCT *psObj
        );

static SMSAPI_RETURN_CODE_ENUM eGetCidFromTags(
    TAG_OBJECT hTag,
    CID_OBJECT *phCID
        );

static SMSAPI_RETURN_CODE_ENUM eGetMarketNameIdTextFromTags(
    TAG_OBJECT hTag,
    STRING_OBJECT *phMarketIdText,
    STRING_OBJECT *phMarketNameText
        );

static SMSAPI_RETURN_CODE_ENUM eSetMarketNameIdTextToTags (
    TAG_OBJECT hTag,
    STRING_OBJECT hMarketIdText,
    STRING_OBJECT hMarketNameText
        );

static SMSAPI_RETURN_CODE_ENUM eWriteTextToTag(
    TAG_OBJECT hParentTag,
    const char *pacTagName,
    STRING_OBJECT hText
        );

static SMSAPI_RETURN_CODE_ENUM eAddToConfigFile (
    TAG_OBJECT hParentTag,
    void *pvItem,
    STRING_OBJECT hMarketIdString,
    STRING_OBJECT hMarketNameTextString
        );

static BOOLEAN bReportIteratorCallback(
    const char *pacId,
    const char *pacName,
    CID_OBJECT hId,
    void *pvContentIteratorCallbackArg
        );

static SMSAPI_RETURN_CODE_ENUM eRegisterMkt(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    CID_OBJECT hMarketCID,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

  /***************/
 /** VARIABLES **/
/***************/
// service specific interface for the TW Seek Service
static const SEEK_SERVICE_SPECIFIC_INTERFACE_STRUCT gsTWSeekInterface =
{
    /*.bInit = */bInit,
    /*.vUnInit = */NULL,
    /*.n32FPrintf = */NULL,
    /*.bHandleSeekAlert = */bHandleSeekAlert
};

// the traffic/weather content interface struct which gets placed into the
// traffic/weather seek service info struct
extern const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsTWSeekContent;

// service specific info struct for the TW Seek Service
const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsTWSeek =
{
    /*.eService = */SEEK_SERVICE_TRAFFIC_WEATHER,
    /*.psInterface = */&gsTWSeekInterface,
    /*.psContentInterface = */&GsTWSeekContent
};

// Global instance of an interface for this object
const TW_SEEK_INTERFACE_STRUCT TW_SEEK =
{
    /*.eAvailableToRegister = */eAvailableToRegister,
    /*.eRegister = */eRegister,
    /*.eRegisterMarket = */eRegisterMarket
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _TW_SEEK_H
