/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _TUNEMIX_OBJ_H_
#define _TUNEMIX_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"
#include "tag_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define TUNEMIX_OVERRIDE             0x01
#define TUNEMIX_PLAY_UNRESTRICTED    0x02

#define TUNEMIX_INVALID_OBJECT_STRUCT_PTR ((TUNEMIX_OBJECT_STRUCT*)NULL)

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct tunemix_object_struct
{
    // The decoder in which this service operates
    DECODER_OBJECT hDecoder;

    // TuneMix index
    UN8 un8Index;

    // TuneMix ID
    CHANNEL_ID tChannelID;

    // TuneMix name
    STRING_OBJECT hName;

    // Reference to Decoder's channels cache
    CCACHE_OBJECT hCCache;

    // The handle of fake channel
    CHANNEL_OBJECT hChannel;

    // List of channels to be mixed up in this TuneMix
    OSAL_OBJECT_HDL hComponentList;

    // Status of TuneMix
    TUNEMIX_STATUS_ENUM eStatus;

    // TuneMix Tag Handle
    TAG_OBJECT hTag;

    // Overrides saved when TuneMix creating
    BOOLEAN bOverride;
    BOOLEAN bPlayUnrestricted;

} TUNEMIX_OBJECT_STRUCT;

typedef struct tunemix_restore_struct
{
    // Operation Result
    BOOLEAN bSuccess;

    SERVICE_ID atServiceId[TUNEMIX_CHANNELS_MAX];

    // Iteration Index
    UN16 un16ChIndex;

} TUNEMIX_RESTORE_STRUCT;

typedef struct tunemix_overrides_struct
{
    BOOLEAN bOverride;
    BOOLEAN bPlayUnrestricted;

} TUNEMIX_OVERRIDES_STRUCT;

typedef struct tunemix_qualify_iterator_struct
{
    UN16 un16Count;
    CCACHE_OBJECT hCCache;
    UN16 un16Unrestricted;

} TUNEMIX_QUALIFY_ITERATOR_STRUCT;

typedef struct tunemix_components_iterator_struct
{
    TUNEMIX_CHANNELS_ITERATOR_CALLBACK bIterateFxn;
    void *pvArg;
    CCACHE_OBJECT hCCache;

} TUNEMIX_COMPONENTS_ITERATOR_STRUCT;

typedef struct tunemix_presets_iterator_struct
{
    SERVICE_ID tSID;
    size_t tLastBandIndex;
    size_t tLastPresetIndex;

} TUNEMIX_PRESETS_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static TUNEMIX_OBJECT hCreate (
    DECODER_OBJECT hDecoder,
    BOOLEAN bOverride,
    BOOLEAN bPlayUnrestricted
        );

static void vDestroy (
    TUNEMIX_OBJECT hTuneMix
        );

static TUNEMIX_OBJECT hActive (
    DECODER_OBJECT hDecoder
        );

static CHANNEL_ID tChannelID (
    TUNEMIX_OBJECT hTuneMix
        );

static SMSAPI_RETURN_CODE_ENUM eTune (
    TUNEMIX_OBJECT hTuneMix
        );

static SMSAPI_RETURN_CODE_ENUM eConfigure (
    TUNEMIX_OBJECT hTuneMix,
    CHANNEL_ID *ptChannelId,
    UN16 un16Count
        );

static SMSAPI_RETURN_CODE_ENUM eIterate (
    DECODER_OBJECT hDecoder,
    TUNEMIX_ITERATOR_CALLBACK bIterateFxn,
    void *pvArg
        );

static TUNEMIX_STATUS_ENUM eStatus (
    TUNEMIX_OBJECT hTuneMix
        );

static SMSAPI_RETURN_CODE_ENUM eIterateChannels (
    TUNEMIX_OBJECT hTuneMix,
    TUNEMIX_CHANNELS_ITERATOR_CALLBACK bIterateFxn,
    void *pvArg
        );

static SMSAPI_RETURN_CODE_ENUM eSetOverrides (
    TUNEMIX_OBJECT hTuneMix,
    BOOLEAN bOverride,
    BOOLEAN bPlayUnrestricted
        );

static SMSAPI_RETURN_CODE_ENUM eGetOverrides (
    TUNEMIX_OBJECT hTuneMix,
    BOOLEAN *pbOverride,
    BOOLEAN *pbPlayUnrestricted
        );

static STRING_OBJECT hGetName (
    TUNEMIX_OBJECT hTuneMix
        );

static SMSAPI_RETURN_CODE_ENUM eSetName (
    TUNEMIX_OBJECT hTuneMix,
    char *pacName
        );

/* Object Private Prototypes */

static SMSAPI_RETURN_CODE_ENUM eFillComponentList (
    TUNEMIX_OBJECT hTuneMix,
    CHANNEL_ID *ptServiceId,
    CHANNEL_ID *ptChannelId,
    UN16 un16Count,
    BOOLEAN bCreateIfNotFound
        );

static void vGetComponentProperties(
    CHANNEL_OBJECT hChannel,
    BOOLEAN *pbIsMusic,
    BOOLEAN *pbIsSubscribed,
    BOOLEAN *pbIsRestricted
        );

static BOOLEAN bIterateForQualified (
    CHANNEL_ID tChannelId,
    void *pvArg
        );

static BOOLEAN bCreateTuneMixTag (
    TUNEMIX_OBJECT_STRUCT *psObj
        );

static BOOLEAN bSaveActive (
    TAG_OBJECT hParentTag,
    BOOLEAN bActive
        );

static BOOLEAN bSaveName (
    TAG_OBJECT hParentTag,
    STRING_OBJECT hName
        );

static BOOLEAN bSaveOverrides (
    TAG_OBJECT hParentTag,
    BOOLEAN bOverride,
    BOOLEAN bPlayUnrestricted
        );

static BOOLEAN bRestoreIterator (
    TAG_OBJECT hTag,
    void *pvArg
        );

static BOOLEAN bTMIterator (
    TAG_OBJECT hTagTMChannel,
    void * pvArg
        );

static BOOLEAN bChannelIterator (
    CHANNEL_ID tChannelId,
    void *pvArg
        );

static void vUninitObject (
    TUNEMIX_OBJECT_STRUCT *psObj
        );

static TUNEMIX_OBJECT_STRUCT *psCreateObject (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId
        );

static N16 n16TuneMixRemoveIterator (
    PRESETS_OBJECT hPresets,
    PRESET_BAND_OBJECT hBand,
    size_t tBandIndex,
    CHANNEL_OBJECT hChannel,
    STRING_OBJECT hPresetName,
    size_t tPresetIndex,
    void *pvIterateArg
    );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const TUNEMIX_OBJECT_INTERFACE_STRUCT TUNEMIX =
{
    /*.hCreate = */hCreate,
    /*.vDestroy = */vDestroy,
    /*.hActive = */hActive,
    /*.tChannelID = */tChannelID,
    /*.eTune = */eTune,
    /*.eConfigure = */eConfigure,
    /*.eIterate = */eIterate,
    /*.eStatus = */eStatus,
    /*.eIterateChannels = */eIterateChannels,
    /*.eSetOverrides = */eSetOverrides,
    /*.eGetOverrides = */eGetOverrides,
    /*.hGetName = */hGetName,
    /*.eSetName = */eSetName

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _TUNEMIX_OBJ_H_
