/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _TRAFFIC_MSG_IMAGE_OBJ_H_
#define _TRAFFIC_MSG_IMAGE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_api.h"
#include "traffic_msg_base_obj.h"
#include "trafcam_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define TRAFFIC_MSG_IMAGE_OBJECT_NAME "TRAFFIC_MSG_IMAGE"

#define TRAFFIC_MSG_IMAGE_DESC_TEXT_OUTPUT_LENGTH 50
#define TRAFFIC_MSG_IMAGE_PATH_OUTPUT_LENGTH 50
#define TRAFFIC_MSG_IMAGE_TIME_TEXT_LENGTH 256

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct traffic_msg_image_object_struct
{
    IMAGE_OBJECT hImage;
    LOCATION_OBJECT hLocation;
    UN32 un32ProcessTimeStamp;
    TRAFCAM_IMAGE_HASH tHash;
    STRING_OBJECT hText;
    UN16 un16Direction;
    UN16 un16TTL;
    UN32 un32TimeToExpire;
} TRAFFIC_MSG_IMAGE_OBJECT_STRUCT;

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static TRAFFIC_MSG_TYPE_ENUM eType(
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg
        );

static STRING_OBJECT hText (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg
        );

static UN32 un32StartTime (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg
        );

static UN8 un8NumLocations (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg
        );

static LOCATION_OBJECT hGetLocation (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg,
    UN8 un8Index
        );

static N32 n32FPrintf (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static SMSAPI_RETURN_CODE_ENUM eIterateLocations (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg,
    TRAFFIC_MSG_LOCATION_ITERATOR bIterator,
    void *pvIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM eCameraDirection (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg,
    UN16 *pun16Direction
        );

static IMAGE_OBJECT hImage (
    TRAFFIC_MSG_BASE_OBJECT hTrafficBaseMsg
        );

static BOOLEAN bCopyFileNameCallback (
    IMAGE_OBJECT hImage,
    const char *pacFilePath,
    void *pvSpecificData,
    char *pacBuffer,
    size_t tBufferSize
        );

static BOOLEAN bGetFileNameLength (
    IMAGE_OBJECT hImage,
    const char *pacFilePath,
    void *pvSpecificData,
    size_t *ptLength
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const TRAFFIC_MSG_BASE_OBJECT_INTERFACE_STRUCT TRAFFIC_MSG_IMAGE =
{
    /*.eType = */eType,
    /*.eClass = */NULL,
    /*.eSpeed = */NULL,
    /*.eDuration = */NULL,
    /*.eDirection = */NULL,
    /*.bDiversionAdvised = */NULL,
    /*.tEventCode = */NULL,
    /*.hText = */hText,
    /*.hAdditionalText = */NULL,
    /*.un32StartTime = */un32StartTime,
    /*.un32StopTime = */NULL,
    /*.un8GetFreeFormData = */NULL,
    /*.un8NumLocations = */un8NumLocations,
    /*.hGetLocation = */hGetLocation,
    /*.n32FPrintf = */n32FPrintf,
    /*.eIterateLocations = */eIterateLocations,
    /*.eCameraDirection = */eCameraDirection,
    /*.hImage = */hImage
};

// IMAGE object specific interface implementation
static const IMAGE_INTF_STRUCT GsTrafficMsgImageIntf =
{
    /*.tSpecificDataSize = */ 0,
    /*.bInitSpecificData = */ NULL,
    /*.bCreationPostStep = */ NULL,
    /*.vUninitSpecificData = */ NULL,
    /*.bCalculateImageFileNameLen = */ bGetFileNameLength,
    /*.bCreateImageFileName = */ bCopyFileNameCallback,
    /*.eProperty = */ NULL,
    /*.eUpdateProperty = */ NULL
};

#endif /* _TRAFFIC_MSG_IMAGE_OBJ_H_ */
