/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _TRAFFIC_MSG_BASE_OBJ_H_
#define _TRAFFIC_MSG_BASE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "traffic_msg_base_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct traffic_msg_base_struct
{
    const TRAFFIC_MSG_BASE_OBJECT_INTERFACE_STRUCT *psIntf;
    void *pvData;
} TRAFFIC_MSG_BASE_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static TRAFFIC_MSG_TYPE_ENUM eType(
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static TRAFFIC_MSG_CLASS_ENUM eClass (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static TRAFFIC_SPEED_ENUM eSpeed (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static TRAFFIC_DURATION_ENUM eDuration (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static TRAFFIC_DIRECTION_ENUM eDirection (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static BOOLEAN bDiversionAdvised (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static TRAFFIC_EVENT_CODE tEventCode (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static STRING_OBJECT hText (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static STRING_OBJECT hAdditionalText (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static UN32 un32StartTime (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static UN32 un32StopTime (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static UN8 un8GetFreeFormData (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    ALERTC_FREEFORM_DATA_LABEL_ENUM eLabel,
    UN16 *paun16Values,
    size_t tCount
        );

static UN8 un8NumLocations (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );

static LOCATION_OBJECT hGetLocation (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    UN8 un8Index
        );

static N32 n32FPrintf (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static SMSAPI_RETURN_CODE_ENUM eIterateLocations (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    TRAFFIC_MSG_LOCATION_ITERATOR bIterator,
    void *pvIteratorArg
        );

static SMSAPI_RETURN_CODE_ENUM eCameraDirection (
    TRAFFIC_MSG_OBJECT hTrafficMsg,
    UN16 *pun16Direction
        );

static IMAGE_OBJECT hImage (
    TRAFFIC_MSG_OBJECT hTrafficMsg
        );


  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const TRAFFIC_MSG_OBJECT_INTERFACE_STRUCT TRAFFIC_MSG =
{
    /*.eType = */eType,
    /*.eClass = */eClass,
    /*.eSpeed = */eSpeed,
    /*.eDuration = */eDuration,
    /*.eDirection = */eDirection,
    /*.bDiversionAdvised = */bDiversionAdvised,
    /*.tEventCode = */tEventCode,
    /*.hText = */hText,
    /*.hAdditionalText = */hAdditionalText,
    /*.un32StartTime = */un32StartTime,
    /*.un32StopTime = */un32StopTime,
    /*.un8GetFreeFormData = */un8GetFreeFormData,
    /*.un8NumLocations = */un8NumLocations,
    /*.hGetLocation = */hGetLocation,
    /*.n32FPrintf = */n32FPrintf,
    /*.eIterateLocations = */eIterateLocations,
    /*.eCameraDirection */eCameraDirection,
    /*.hImage = */hImage
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _TRAFFIC_MSG_BASE_OBJ_H_
