/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _THEATER_TIMES_OBJ_H_
#define _THEATER_TIMES_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

#include "sql_interface_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define THEATER_TIMES_OBJECT_NAME "THEATER_TIMES"

#define NUM_MOVIE_TIMES_ENTRYS_IN_BLOCK     (4)

#define SECONDS_IN_FIVE_MINUTES             (5*60)

  /**************/
 /** TYPEDEFS **/
/**************/

// Structure which stores ratings exception data
typedef struct movie_rating_exception_struct
{
    MOVIE_RATING_SYS_CODE tSysCode;
    MOVIE_RATING_SYSTEM_ENUM eSystem;
    MOVIE_RATING_CODE tRatingCode;
    MOVIE_RATING_ENUM eRating;
    STRING_OBJECT hRatingText;

} MOVIE_RATING_EXCEPTION_STRUCT;

typedef struct movie_times_entry_struct
{
    struct movie_times_entry_block_struct *psHeader;

    BOOLEAN bInUse;

    MOVIE_ID tID;

    BOOLEAN bHaveException;
    MOVIE_RATING_EXCEPTION_STRUCT sException;

    UN8 un8NumShowTimes;

    // Values are 5-minute increments from the initial time located
    // in the THEATER_TIMES_OBJECT_STRUCT
    UN16 aun16TimeOffsets[MOVIES_THEATER_TIMES_MAX_NUM_TIME_OFFSETS];
} MOVIE_TIMES_ENTRY_STRUCT;

typedef struct movie_times_entry_block_struct
{
    OSAL_LINKED_LIST_ENTRY ahEntries[NUM_MOVIE_TIMES_ENTRYS_IN_BLOCK];
    MOVIE_TIMES_ENTRY_STRUCT asData[NUM_MOVIE_TIMES_ENTRYS_IN_BLOCK];

} MOVIE_TIMES_ENTRY_BLOCK_STRUCT;

typedef struct theater_times_object_struct
{
    MOVIES_SERVICE_OBJECT hMoviesService;

    // The system-wide unique ID for this theater
    THEATER_ID tID;

    // A list of MOVIE_TIMES_ENTRY_STRUCT pointers
    OSAL_OBJECT_HDL hMovieList;
    UN8 un8NumMovies;
    UN8 un8NumBlocks;

    // All time offsets in the MOVIE_TIMES_ENTRY_STRUCT
    // are offsets from this time.  All times are in the
    // local timezone for the theater's location
    UN32 un32InitialTime;

    // A handle to the current movie entry we are iterating
    MOVIE_TIMES_ENTRY_STRUCT *psCurMovieEntry;
    MOVIE_OBJECT hCurMovie;

} THEATER_TIMES_OBJECT_STRUCT;

typedef struct movie_iterator_struct
{
    THEATER_TIMES_OBJECT_STRUCT *psTheaterTimes;

    SMS_OBJECT hParent;
    THEATER_OBJECT hTheater;
    THEATER_MOVIES_ITERATOR bIterator;
    void *pvIteratorArg;

} MOVIE_ITERATOR_STRUCT;

typedef struct create_theater_times_blob_iterator_struct
{
    size_t tNumUN16sWritten;
    UN16 *pun16BlobData;
    size_t tBlobDataSize;
    BOOLEAN bError;

} CREATE_THEATER_TIMES_BLOB_ITERATOR_STRUCT;

// Enumeration specifying all the available fields
// in the theater times table
typedef enum theater_times_fields_enum {
    THEATER_TIMES_ID = 0,
    THEATER_TIMES_INITIAL_TIME,
    THEATER_TIMES_NUM_MOVIES,
    THEATER_TIMES_DATA_COUNT,
    THEATER_TIMES_DATA_BLOB,
    THEATER_TIMES_MAX_FIELDS

} THEATER_TIMES_FIELDS_ENUM;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Private Prototypes */
static BOOLEAN bSetupTheaterTimes (
    THEATER_TIMES_OBJECT_STRUCT *psObj,
    THEATER_ID tID,
    UN32 un32InitialTime,
    UN8 un8NumMovies
        );

static BOOLEAN bProcessTimesFromRow (
    THEATER_TIMES_OBJECT_STRUCT *psObj,
    THEATER_TIMES_ROW_STRUCT *psTimesRow
        );

static BOOLEAN bResetObject (
    THEATER_TIMES_OBJECT_STRUCT *psObj
        );

static void vDestroyObject (
    THEATER_TIMES_OBJECT_STRUCT *psObj
        );

static void vReleaseBlock (
    MOVIE_TIMES_ENTRY_STRUCT *psEntry
        );

static MOVIE_TIMES_ENTRY_STRUCT *psFindMovieEntry (
    THEATER_TIMES_OBJECT_STRUCT *psObj,
    BOOLEAN bInUse,
    MOVIE_ID tID,
    OSAL_LINKED_LIST_ENTRY *phEntry
        );

static BOOLEAN bResetMovieEntry (
    MOVIE_TIMES_ENTRY_STRUCT *psEntry,
    void *pvArg
        );

static BOOLEAN bIterateMovies (
    MOVIE_TIMES_ENTRY_STRUCT *psEntry,
    MOVIE_ITERATOR_STRUCT *psIterator
        );

static BOOLEAN bAddMovieTimesDataToBlob (
    MOVIE_TIMES_ENTRY_STRUCT *psEntry,
    CREATE_THEATER_TIMES_BLOB_ITERATOR_STRUCT *psIterator
        );

static N16 n16CompareMovieEntry (
    MOVIE_TIMES_ENTRY_STRUCT *psEntry1,
    MOVIE_TIMES_ENTRY_STRUCT *psEntry2
        );

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _THEATER_TIMES_OBJ_H_
