/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _TAG_OBJ_H_
#define _TAG_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

// Object name prefix for objects
#define TAG_OBJECT_NAME "TAG"

// the number of bytes required to hold the largest possible integer as a string
#define STRING_LENGTH_FOR_INTEGER (12)

#define WRITE_LITERAL(file, literal) \
    fwrite((literal), sizeof(char), sizeof(literal)/sizeof(char)-1, (file))

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct tag_object_struct
{
    char *pacNamesBuffer;

    STRING_OBJECT hTagName;
    STRING_OBJECT hTagInstanceIdentifier;
    STRING_OBJECT hTagValue;

    // Child Tag List
    OSAL_OBJECT_HDL hChildList;

    // This Tag's Entry in it's parent's child list
    OSAL_LINKED_LIST_ENTRY hEntry;
    TAG_OBJECT hParentTag;

    // flag, which if TRUE, indicates this tag has been removed
    BOOLEAN bRemoved;

} TAG_OBJECT_STRUCT;

typedef struct tag_write_iterator_struct
{
    FILE *psFile;
    N16 n16IndentLevel;
    N32 n32NumWritten;
} TAG_WRITE_ITERATOR_STRUCT;

typedef struct tag_search_iterator_struct
{
    const char *pacName;
    const char *pacInstanceIdentifier;
    TAG_OBJECT hTag;
} TAG_SEARCH_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */

static SMSAPI_RETURN_CODE_ENUM eModifyValueCStr(
    TAG_OBJECT_STRUCT *psObj,
    const char *pacValue
        );

static SMSAPI_RETURN_CODE_ENUM eModifyValue(
    TAG_OBJECT_STRUCT *psObj,
    STRING_OBJECT hString
        );

static SMSAPI_RETURN_CODE_ENUM eSetParentTag(
    TAG_OBJECT hChildTag,
    TAG_OBJECT hParentTag,
    OSAL_LINKED_LIST_ENTRY hEntry
        );

static N32 n32WriteTagNameToFile(
    TAG_OBJECT_STRUCT *psObj,
    FILE *psFile,
    BOOLEAN bCloseTag
        );

static void vMarkRemoved(
    TAG_OBJECT hTag,
    BOOLEAN *pbError
        );

static SMSAPI_RETURN_CODE_ENUM eAddTag(
    const char *pacName,
    TAG_OBJECT_STRUCT *psObj,
    TAG_OBJECT *phNewTag,
    const char *pacIdentifier
        );

static BOOLEAN bWriteTagIterator(
    void *pvData,
    void *pvArg
        );

static BOOLEAN bChildListIterator(
    void *pvData,
    void *pvArg
        );

static BOOLEAN bMarkRemovedIterator(
    void *pvData,
    void *pvArg
        );

static size_t tEncodeBase64(
    const UN8 *paun8Source,
    size_t tSourceSize,
    char *pacTarget,
    size_t tTargetSize
        );

static size_t tDecodeBase64(
    const char *pacSource,
    UN8 *paun8Target,
    size_t tTargetSize
        );

static size_t tGetDecodedLength(
    size_t tEncodedStringLength
        );

static size_t tGetEncodedStringLength(
    size_t tDecodedLength
        );

  /***************/
 /** VARIABLES **/
/***************/

// conversion tables for base64

// this table is used to decode
const UN8 gaun8CharToBase64Tbl[128] =
    {  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0, 62,  0,  0,  0, 63,
      52, 53, 54, 55, 56, 57, 58, 59,
      60, 61,  0,  0,  0,  0,  0,  0,
       0,  0,  1,  2,  3,  4,  5,  6,
       7,  8,  9, 10, 11, 12, 13, 14,
      15, 16, 17, 18, 19, 20, 21, 22,
      23, 24, 25,  0,  0,  0,  0,  0,
       0, 26, 27, 28, 29, 30, 31, 32,
      33, 34, 35, 36, 37, 38, 39, 40,
      41, 42, 43, 44, 45, 46, 47, 48,
      49, 50, 51,  0,  0,  0,  0,  0 };

// this table is used to encode
const char gacBase64ToCharTbl[64] =
    {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
     'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
     'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
     'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
     'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
     'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
     'w', 'x', 'y', 'z', '0', '1', '2', '3',
     '4', '5', '6', '7', '8', '9', '+', '/' };

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _TAG_OBJ_H_
