/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the Object:SUBSCRIPTION private header file.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SUB_NOTIFICATION_H_
#define _SUB_NOTIFICATION_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

// 2min * 60sec/min * 1000msec/sec
#define SUB_NOTIFICATION_META_WAIT_DURATION_MS (2 * 60 * 1000)

// 30sec/min * 1000msec/sec
#define SUB_NOTIFICATION_TEXT_REPLACE_DURATION_MS (30 * 1000)

#define DAY_IN_SECONDS (24*60*60)

/* Object name prefix for objects */
#define SUB_NOTIFICATION_OBJECT_NAME "SUBSCRIPTION"

#define SUB_NOTIFICATION_TAG_NAME "Subscription"

#define PERIOD_TAG_NAME "Period"

  /**************/
 /** TYPEDEFS **/
/**************/

//  The SUB_NOTIFICATION structure
typedef struct subscription_service_object_struct
{
  	OSAL_OBJECT_HDL hMetadataWaitTimer;
    SMS_EVENT_HDL hMetaWaitEvent;

	OSAL_OBJECT_HDL hTextReplaceTimer;
    SMS_EVENT_HDL hTextReplacementEvent;

    BOOLEAN bMetaNotificationDone;
    BOOLEAN bTuneNotificationDone;

    UN8 un8Period;

    SUB_NOTIFICATION_STATE_ENUM eCurrentState;

    CHANNEL_OBJECT hTunedChannel;

} SUB_NOTIFICATION_OBJECT_STRUCT;

// un8Period1UpperLimit is the number of days before the end of
// subscription which defines the start of notifiation period 1
// un8Period2UpperLimit is the number of days before the end of
// subscription which defines the start of notifiation period 2
// Period 1 occurs before Period 2.
typedef struct subscription_reason_code_struct
{
    UN8 un8ReasonCode;
    UN8 un8Period1UpperLimit;
    UN8 un8Period2UpperLimit;
    const char *pacReasonText;
    const char *pacPhoneNumberText;

} SUB_NOTIFICATION_REASON_CODE_STRUCT;


  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static SMSAPI_RETURN_CODE_ENUM eStart (
    DECODER_OBJECT hDecoder
        );

static void vStop (
    DECODER_OBJECT hDecoder
        );

static SUB_NOTIFICATION_STATE_ENUM eState (
    DECODER_OBJECT hDecoder
        );

/* Object Private Prototypes */

static BOOLEAN bCheckPeriod(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static BOOLEAN bManagerFSM (
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj,
    SUB_NOTIFICATION_STATE_ENUM eRequestedState
        );

static BOOLEAN bAlreadyNotified(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj,
    UN8 un8Period
        );

static BOOLEAN bNotified(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static SUB_NOTIFICATION_STATE_ENUM eTransitionToInitialState(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static SUB_NOTIFICATION_STATE_ENUM eTransitionToWaitState(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static SUB_NOTIFICATION_STATE_ENUM eTransitionToTuneState(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static SUB_NOTIFICATION_STATE_ENUM eTransitionToMetadataState(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static SUB_NOTIFICATION_STATE_ENUM eTransitionToNotReqdState(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj);

static SUB_NOTIFICATION_STATE_ENUM eTransitionToCompleteState(
	SUB_NOTIFICATION_OBJECT_STRUCT *psObj
		);
static const char *pacSubStateText(
    SUB_NOTIFICATION_STATE_ENUM eState
        );

static void vTextReplacementTimerCallback (
    OSAL_OBJECT_HDL hTimer,
    void *pvArg
        );

static void vMetadataWaitTimerCallback (
    OSAL_OBJECT_HDL hTimer,
    void *pvArg
        );

static BOOLEAN bSubscriptionAlert (
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static SUB_NOTIFICATION_STATE_ENUM eRefreshTunedState (
	SUB_NOTIFICATION_OBJECT_STRUCT *psObj
		);

static BOOLEAN bMetadataReplacement(
    SUB_NOTIFICATION_OBJECT_STRUCT *psObj
        );

static void vChannelMetadataEventCallback (
    CHANNEL_OBJECT hChannel,
    CHANNEL_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// All fixed reason code mappings per:
// Phase 1 use cases for BRD _with SXM use cases included_rev 6_Final.xlsx
#define KNOWN_REASON_CODES (10)

#define RENEW_SXM      "Renew SXM Call"
#define CALL_SXM       "Call SiriusXM"

static const SUB_NOTIFICATION_REASON_CODE_STRUCT gasReasonCode[KNOWN_REASON_CODES] =
{
    // End of Prepaid Trial US/Canada (Ford)
    // Use Case Id: SN0023 SN0025
    {
        8,
        28,
        9,
        RENEW_SXM,
        "855-99-RENEW"
    },

    // End of Prepaid Trial US/Canada (other legacy low band)
    // Use Case Id: SN0024 SN0026
    {
        2,
        28,
        9,
        RENEW_SXM,
        "855-88-RENEW"
    },

    // End of Prepaid Trial US (all legacy high band)
    // Use Case Id: SN0027
    {
        4,
        28,
        9,
        RENEW_SXM,
        "855-RENEW-55"
    },

    // End of Prepaid Trial Canada (all legacy high band)
    // Use Case Id: SN0028
    {
        5,
        28,
        9,
        RENEW_SXM,
        "877-438-9677"
    },

    // End of Self pay credit card US/Canada Ford/All other legacy low band
    // Use Case Id: SN0029 SN0030 SN0031 SN0032
    {
        9,
        28,
        4,
        CALL_SXM,
        "866-303-7474"
    },

    // End of Self pay credit card US All legacy high band
    // Use Case Id: SN0033
    {
        11,
        28,
        4,
        CALL_SXM,
        "800-967-2356"
    },

    // End of Self pay credit card Canada All legacy high band
    // Use Case Id: SN0034
    {
        12,
        28,
        4,
        CALL_SXM,
        "877-438-9677"
    },

    // End of Self pay invoice US/Canada Ford/All other legacy low band
    // Use Case Id: SN0035 SN0036 SN0037 SN0038
    {
        10,
        10,
        4,
        CALL_SXM,
        "866-303-7474"
    },

    // End of Self pay invoice US All legacy high band
    // Use Case Id: SN0039
    {
        0,
        10,
        4,
        CALL_SXM,
        "800-967-2356"
    },

    // End of Self pay invoice Canada All legacy high band
    // Use Case Id: SN0040
    {
        7,
        10,
        4,
        CALL_SXM,
        "877-438-9677"
    }
};

// Global instance of an interface for this object
const SUB_NOTIFICATION_OBJECT_INTERFACE_STRUCT SUB_NOTIFICATION =
{
    /*.eStart = */eStart,
    /*.vStop = */vStop,
    /*.eState = */eState
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif
