/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*             Licensed Materials - Property of Sirius XM Radio, Inc.         */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _STOCK_SYMBOL_OBJ_H_
#define _STOCK_SYMBOL_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdio.h>
#include <string.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "stock_ticker_interface.h"
#include "stock_symbol_obj.h"
#include "dsrl_target_obj.h"
#include "string_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define STOCK_SYMBOL_OBJECT_NAME "STOCK_SYMBOL"

/* Object tag name */
#define STOCK_SYMBOL_TAG_NAME "StockSymbol"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct stock_symbol_object_struct
{
    // Original symbol name string
    STRING_OBJECT hName;
} STOCK_SYMBOL_OBJECT_STRUCT;

typedef struct stock_tag_search_struct
{
    struct
    {
        // Stock symbol name in case of by-name
        STRING_OBJECT hSymbol;
    } sInput;
    struct
    {
        // Appropriate tar handle
        TAG_OBJECT hTag;
    } sOutput;
} STOCK_SYMBOL_TAG_SEARCH_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static STOCK_SYMBOL_OBJECT hCreate (
    STRING_OBJECT hName
        );

static N32 n32FWrite (
    STOCK_SYMBOL_OBJECT hTarget,
    FILE *psFile
        );

static STOCK_SYMBOL_OBJECT hFRead (
    FILE *psFile
        );

static N32 n32FPrintf (
    STOCK_SYMBOL_OBJECT hTarget,
    FILE *psFile
        );

static void vDestroy (
    STOCK_SYMBOL_OBJECT hTarget
        );

static STOCK_SYMBOL_OBJECT_STRUCT *psCreateObject(
    SMS_OBJECT hParent
        );

static BOOLEAN bFindStockTag (
    TAG_OBJECT hTag,
    STOCK_SYMBOL_TAG_SEARCH_STRUCT *psSearch
        );

static void vObjectDestroy(
    STOCK_SYMBOL_OBJECT_STRUCT *psObj
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const STOCK_SYMBOL_INTERFACE_STRUCT STOCK_SYMBOL = {
    /*.hCreate = */           hCreate,
    /*.n32FWrite = */         n32FWrite,
    /*.hFRead = */            hFRead,
    /*.n32FPrintf = */        n32FPrintf,
    /*.vDestroy = */          vDestroy
};

#endif /* _STOCK_SYMBOL_OBJ_H_ */
