/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SP_SEEK_H
#define _SP_SEEK_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

#include "tag_obj.h"
#include "seek.h"
#include "seek_content.h"
#include "sp_seek.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SP_SEEK_OBJECT_NAME "SP_SEEK"

#define SP_SEEK_CAL_AUTO_ADD_OPTIONS \
         ( CAL_AUTO_ADD_OPTION_IF_TUNED  | \
           CAL_AUTO_ADD_OPTION_IF_NOT_TUNED  | \
           CAL_AUTO_ADD_OPTION_UNIQUE | \
           CAL_AUTO_ADD_OPTION_TOP  )

// names of tags
#define SP_SEEK_ENABLED                "Enabled"
#define SP_SEEK_LEAGUE_CID             "LeagueCID"
#define SP_SEEK_TEAM_CID               "TeamCID"
#define SP_SEEK_TYPE                   "Type"

#define SP_SEEK_NAME_TEXT              "Name"
#define SP_SEEK_ABBREV_TEXT            "Abbrev"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct registered_content_tag_iterator_struct
{
    SEEK_SERVICE_OBJECT_STRUCT *psObj;
} REGISTERED_CONTENT_TAG_ITERATOR_STRUCT;

typedef struct sp_seek_iterator_struct
{
    BOOLEAN bMatch;
    CID_OBJECT hId;
} SP_SEEK_ITERATOR_STRUCT;

typedef struct sp_seek_league_iterator_struct
{
    CID_OBJECT hLeagueId;
    CID_OBJECT hTeamId;
    STRING_OBJECT hName;
    STRING_OBJECT hAbbreviation;
    BOOLEAN bFound;
    SP_SEEK_ENUM eType;
} SP_SEEK_LEAGUE_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eAvailableToRegister (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    SEEK_AVAILABILTY_ENUM *peAvailablility,
    SP_SEEK_ENUM eType,
    ...
        );

static SMSAPI_RETURN_CODE_ENUM eRegister (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    SP_SEEK_ENUM eType,
    SEEK_CONTENT_OBJECT *phSeekContent,
    ...
        );

static SMSAPI_RETURN_CODE_ENUM eRegisterTeam (
    DECODER_OBJECT hDecoder,
    LEAGUE_OBJECT hLeague,
    TEAM_OBJECT hTeam,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eRegisterLeague (
    DECODER_OBJECT hDecoder,
    LEAGUE_OBJECT hLeague,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

/* Object Private Prototypes */

static BOOLEAN bSeekAlertAllowed(
    SEEK_SERVICE_OBJECT hSeek,
    CAL_CONTENT_OBJECT hContent,
    CHANNEL_OBJECT hChannel
        );

static CD_OBJECT hGetCDO(
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId
        );

static CID_OBJECT hRetrieveCidForSeeks(
    CD_OBJECT hCDO,
    SP_SEEK_ENUM eType,
    UN8 un8Index
        );

static BOOLEAN bHandleSeekAlert(
    SEEK_SERVICE_OBJECT hSeek,
    CAL_ALERT_OBJECT hAlert
        );

static BOOLEAN bInit(
    SEEK_SERVICE_OBJECT hSeek
        );

static BOOLEAN bAddToConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psItem,
    STRING_OBJECT hNameString,
    STRING_OBJECT hAbbrevString
        );

static SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psRegisterContent(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    CID_OBJECT hCID,
    CID_OBJECT hLeagueCID,
    CID_OBJECT hTeamCID,
    STRING_OBJECT hNameString,
    STRING_OBJECT hAbbrevString,
    SP_SEEK_ENUM eType,
    SMSAPI_RETURN_CODE_ENUM *peReturn,
    BOOLEAN bEnabled,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static BOOLEAN bRegisterContentFromConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRegisteredContentTagIterator(
    TAG_OBJECT hTag,
    void *pvArg
        );

static SP_SEEK_ENUM eGetSPSeekTypeFromTags(
    TAG_OBJECT hTag
        );

static SMSAPI_RETURN_CODE_ENUM eGetEnabledFromTag(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    TAG_OBJECT hTag,
    BOOLEAN *pbEnabled
        );

static SMSAPI_RETURN_CODE_ENUM eGetCidsFromTags(
    TAG_OBJECT hTag,
    SP_SEEK_ENUM eType,
    CID_OBJECT *phCID,
    CID_OBJECT *phLeagueCID,
    CID_OBJECT *phTeamCID
        );

static SMSAPI_RETURN_CODE_ENUM eGetNameAbbrevTextFromTags(
    TAG_OBJECT hTag,
    STRING_OBJECT *phNameText,
    STRING_OBJECT *phAbbrevText
        );

static SMSAPI_RETURN_CODE_ENUM eSetNameAbbrevTextToTags(
    TAG_OBJECT hTag,
    STRING_OBJECT hNameText,
    STRING_OBJECT hAbbrevText
        );

static SMSAPI_RETURN_CODE_ENUM eWriteTypeToTag(
    TAG_OBJECT hParentTag,
    SP_SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psSPSpecificInfo
        );

static SMSAPI_RETURN_CODE_ENUM eWriteCIDsToTag(
    TAG_OBJECT hParentTag,
    SP_SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psSPSpecificInfo
        );

static SMSAPI_RETURN_CODE_ENUM eWriteTextToTag(
    TAG_OBJECT hParentTag,
    const char *pacTagName,
    STRING_OBJECT hText
        );

static SMSAPI_RETURN_CODE_ENUM eRegisterTeamLocal(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    CID_OBJECT hLeagueId,
    TEAM_OBJECT hTeam,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eRegisterLeagueLocal(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    LEAGUE_OBJECT hLeague,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static SMSAPI_RETURN_CODE_ENUM eAddToConfigFile (
    TAG_OBJECT hParentTag,
    void *pvItem,
    STRING_OBJECT hNameString,
    STRING_OBJECT hAbbrevString
        );

static BOOLEAN bSportSeekContentIterator(
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    SEEK_CONTENT_OBJECT hContent,
    void *pvSeekContentIteratorArg
      );

static BOOLEAN bLeagueIteratorCallback(
    LEAGUE_OBJECT hLeague,
    void *pvContentIteratorCallbackArg
        );

static BOOLEAN bTeamContentIteratorCallback(
    TEAM_OBJECT hTeam,
    void *pvContentIteratorCallbackArg
        );

  /***************/
 /** VARIABLES **/
/***************/
// service specific interface for the TW Seek Service
static const SEEK_SERVICE_SPECIFIC_INTERFACE_STRUCT gsSPSeekInterface =
{
    /*.bInit = */bInit,
    /*.vUnInit = */NULL,
    /*.n32FPrintf = */NULL,
    /*.bHandleSeekAlert = */bHandleSeekAlert
};

// the sports content interface struct which gets placed into the
// sports seek service info struct
extern const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsSPSeekContent;

// service specific info struct for the SP Seek Service
const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsSPSeek =
{
    /*.eService = */SEEK_SERVICE_SPORTS,
    /*.psInterface = */&gsSPSeekInterface,
    /*.psContentInterface = */&GsSPSeekContent
};

// Global instance of an interface for this object
const SP_SEEK_INTERFACE_STRUCT SP_SEEK =
{
    /*.eAvailableToRegister = */eAvailableToRegister,
    /*.eRegister = */eRegister,
    /*.eRegisterTeam = */eRegisterTeam,
    /*.eRegisterLeague = */eRegisterLeague
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SP_SEEK_H
