/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SONGLIST_OBJ_H_
#define _SONGLIST_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_update.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SONGLIST_OBJECT_NAME "SONGLIST"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct songlist_object_struct
{
    // SongList Object Name
    char acName[OSAL_DEV_MAX_NAME_LENGTH_WITH_NULL];

    // Playback on which this songlist can be played
    PLAYBACK_OBJECT hPlayback;

    // Type of channel list
    SONGLIST_TYPE_ENUM eSongListType;

    // Number of songs in list prior(before)/after the reference
    UN16 un16BeforeRequest;
    UN16 un16AfterRequest;

    // Number of songs in list prior(before)/after the reference
    UN16 un16Before;
    UN16 un16After;

    // Song List
    OSAL_OBJECT_HDL hSongList;

    // Reference song
    OSAL_LINKED_LIST_ENTRY hReferenceSongEntry;

    // Top (first) song
    OSAL_LINKED_LIST_ENTRY hTopSongEntry;

    // Bottom (last) channel
    OSAL_LINKED_LIST_ENTRY hBottomSongEntry;

    // Songlist Update Control Structure
    SMSU_EVENT_STRUCT sEvent;

} SONGLIST_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SONGLIST_OBJECT hCreate (
    PLAYBACK_OBJECT hPlayback,
    SONGLIST_TYPE_ENUM eSongListType,
    UN16 un16Before,
    UN16 un16After,
    SONG_EVENT_MASK tEventRequestMask,
    SONGLIST_OBJECT_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg,
	...
        );

static void vDestroy(
    SONGLIST_OBJECT hSongliist
        );

static SONG_OBJECT hSong(
    SONGLIST_OBJECT hSongliist,
    N16 n16Offset
        );

static void vCleanList(
    SONGLIST_OBJECT_STRUCT *psObj
        );

static SMSAPI_RETURN_CODE_ENUM eBrowseList (
    SONGLIST_OBJECT hSonglist,
    N16 n16Offset
        );

static SMSAPI_RETURN_CODE_ENUM eSize (
    SONGLIST_OBJECT hSonglist,
    size_t *ptSize,
    UN16 *pun16Before,
    UN16 *pun16After
        );

static SONGLIST_OBJECT_EVENT_MASK tEventMask(
    SONGLIST_OBJECT hSonglist
        );

/* Object Private Prototypes */
static BOOLEAN bAddSong(
    SONGLIST_OBJECT hSonglist,
	SONG_OBJECT hSong,
	BOOLEAN bBefore
        );

static BOOLEAN bRemoveSong(
    void *pvData,
    void *pvArg
        );

static BOOLEAN bCreateList (
    SONGLIST_OBJECT hSongList
        );

static void vPopulateSongList (
    SONGLIST_OBJECT_STRUCT *psObj,
    SCACHE_OBJECT hSCache,
	N16 n16ReferenceSongOffset
        );

static BOOLEAN bRegisterNotification(
    SONGLIST_OBJECT_STRUCT *psObj,
    SONG_OBJECT hSong
        );

static void vSongEventCallback (
    SONG_OBJECT hSong,
    SONG_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

static void vSCacheEventCallback (
    SCACHE_OBJECT hSCache,
    SCACHE_EVENT_MASK tEventMask,
    void *pvEventCallbackArg
        );

static void vUnregisterNotification(
    SONGLIST_OBJECT_STRUCT *psObj,
    SONG_OBJECT hSong
        );

static void vSCacheInternalEventHandler(
    SONGLIST_OBJECT_STRUCT *psObj,
	SCACHE_OBJECT hSCache,
	SCACHE_EVENT_MASK tEventMask
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const SONGLIST_OBJECT_INTERFACE_STRUCT SONGLIST =
{
    // Public
    /*.hCreate = */hCreate,
    /*.vDestroy = */vDestroy,
    /*.hSong = */hSong,
	/*.eBrowseList = */eBrowseList,
	/*.eSize = */eSize,
    /*.tEventMask = */tEventMask
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SONGLIST_OBJ_H_
