/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SONG_TAG_ID_H_
#define _SONG_TAG_ID_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "cid_obj.h"
#include "cid_integer.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */


  /**************/
 /** TYPEDEFS **/
/**************/
// SONG ID processing and information interface
typedef struct sxi_id_type_interface_struct
{
    // CDO Song Id Tag Parser
    BOOLEAN (*bParser) (
        CD_OBJECT hCDO,
        const void *pvData
            );

    // The ID describing this CDO
    const UN32 un32Id;

} SONG_TAG_ID_TYPE_INTERFACE_STRUCT;

  /************/
 /** MACROS **/
/************/
#define SONG_TAG_ID_MAX_LENGTH    sizeof(UN32)

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */

static BOOLEAN bParseSongTagId (
    CD_OBJECT hCDO,
    const void *pvData
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global structure defining the CID Interface for SONG TAG ID
// Note: The only method implemented directly by the SONG TAG ID module is
// the bParser(). All the other methods do not exist (NULL)
// Also note that the SONG TAG ID object data is a integer and thus we borrow
// the CID INTEGER interface APIs.
const CID_TYPE_INTERFACE_STRUCT GsSongTagIntf =
{
    // CID type
    /*.eType = */CID_SONG_TAG_ID,

    // Init/Unit methods
    /*.bInitialize = */NULL,
    /*.vUnInitialize = */NULL,

    // CID Input Data Parse Method
    /*.bParse = */bParseSongTagId,

    // Object Data Methods
    /*.sObjData = */{

        // Minimum Expected Size (if known, otherwise 0)
        /*.tMinSize = */MAX_INTEGER_AS_CHARS,
        // Object Data Create/Destroy Methods
        /*.pvCreate = */CIDINT_pvCreate,
        /*.vDestroy = */CIDINT_vDestroy,

        // Object Data Manipulation Methods
        /*.pvDuplicate = */CIDINT_pvDuplicate,
        /*.bModify = */CIDINT_bModify,
        /*.bCopy = */CIDINT_bCopy,
        /*.tSize = */CIDINT_tSize,
        /*.n16Compare = */CIDINT_n16Compare,

        // Object Data I/O Methods
        /*.n32FWrite = */CIDINT_n32FWrite,
        /*.n32FWriteToMemory = */CIDINT_n32FWriteToMemory,
        /*.pvRead = */CIDINT_pvRead,
        /*.bReadFromMemory = */CIDINT_bReadFromMemory,
        /*.n32FPrintf = */CIDINT_n32FPrintf,
        /*.n32GetValue = */CIDINT_n32GetValue
    }

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SONG_TAG_ID_H_
