/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SONG_OBJ_H_
#define _SONG_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_update.h"
#include "sms_api_debug.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SONG_OBJECT_NAME "SONG"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct song_object_struct
{
    // current absolute offset of this song in the scache
    N16 n16Offset;

    STRING_OBJECT hTitle;
    STRING_OBJECT hArtist;
    UN32 un32BaseTime;
    UN32 un32Duration;
    UN32 un32TimeStamp;
    CHANNEL_ID tChannelId;
    SMSAPI_SONG_STATUS_ENUM eStatus;

    SONG_ID tId;

    // Song Update Control Structure
    SMSU_EVENT_STRUCT sEvent;

} SONG_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SONG_EVENT_MASK tEventMask (
    SONG_OBJECT hSong
        );

static STRING_OBJECT hTitle (
    SONG_OBJECT hSong
        );

static STRING_OBJECT hArtist (
    SONG_OBJECT hSong
        );

static SMSAPI_RETURN_CODE_ENUM eTimeStamp (
    SONG_OBJECT hSong,
    UN32 *pun32TimeStamp
        );

static SMSAPI_RETURN_CODE_ENUM eDuration (
    SONG_OBJECT hSong,
    UN32 *pun32Duration
        );

static SMSAPI_RETURN_CODE_ENUM eChannelId (
    SONG_OBJECT hSong,
    CHANNEL_ID *ptChannelId
        );

static SMSAPI_RETURN_CODE_ENUM eStatus (
    SONG_OBJECT hSong,
    SMSAPI_SONG_STATUS_ENUM *peStatus
        );

/* Object Private Prototypes */

static char *pcSongStatusToString (
    SMSAPI_SONG_STATUS_ENUM eStatus
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const SONG_OBJECT_INTERFACE_STRUCT SONG =
{
    // Public
    /*.tEventMask = */tEventMask,
    /*.hArtist = */hArtist,
    /*.hTitle = */hTitle,
    /*.eTimeStamp = */eTimeStamp,
    /*.eDuration = */eDuration,
    /*.eChannelId = */eChannelId,
    /*.eStatus = */eStatus
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _SONG_OBJ_H_
