/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SMS_UPDATE_H_
#define _SMS_UPDATE_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sms_update.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct smsu_event_callback_struct
{
    BOOLEAN bActive;

    OSAL_LINKED_LIST_ENTRY hCallbackEntry;

    // Requested Event Mask for the callback
    SMSAPI_EVENT_MASK tRequestMask;

    // Current Mask for this particular callback
    SMSAPI_EVENT_MASK tMask;

    // Object update callback and argument
    SMSAPI_OBJECT_EVENT_CALLBACK vCallback;
    void *pvCallbackArg;

} SMSU_EVENT_CALLBACK_STRUCT;
typedef struct smsu_event_request_mask_mod_struct
{
    // Requested Event Mask to use
    SMSAPI_EVENT_MASK tMask;

    // The type of modification to perform
    SMSAPI_MODIFY_EVENT_MASK_ENUM eModification;

} SMSU_EVENT_REQUEST_MASK_MOD_STRUCT;

typedef struct smsu_event_notification_arg_struct
{
    // Cumulative event mask for all the notifications sent
    SMSAPI_EVENT_MASK tCumulativeMask;

    // Pointer to the SMS Update event structure
    // we are working with
    SMSU_EVENT_STRUCT *psEvent;

} SMSU_EVENT_NOTIFICATION_ARG_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/
static N16 n16CompareCallbacks (
    void *pvObj1,
    void *pvObj2
        );

static N16 n16FindActiveCallbacks (
    void *pvObj1,
    void *pvObj2
        );

static N16 n16FindInactiveCallbacks (
    void *pvObj1,
    void *pvObj2
        );

static BOOLEAN bRemoveCallback (
    SMSU_EVENT_CALLBACK_STRUCT *psCallbackToRemove
        );

static void vReleaseCallbackNode (
    void *pvData
        );

static BOOLEAN bModifyEventMaskIterator (
    void *pvData,
    void *pvArg
        );

static BOOLEAN bUpdateCallbackStructIterator (
    void *pvData,
    void *pvArg
        );

static BOOLEAN bNotifyIterator (
    void *pvData,
    void *pvArg
        );

static void vRemoveInactiveCallbacks (
    SMSU_EVENT_STRUCT *psEvent
        );

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SMS_UPDATE_H_
