/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SMS_H_
#define _SMS_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"
#include "tag_obj.h"
#include "song_tag_service.h"

#include "sms_api.h"
#include "sms.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Configuration */
#define SMS_CONF_FILE "sms.cfg"

/* Object name prefix for objects */
#define SMS_NAME "SMS"

// The number of attempts to uninitialize SMS before giving up
#define SMS_UNINITIALIZE_ATTEMPTS       (12)

// Seconds to wait after each uninitialization attempt.
#define SMS_UNINITIALIZE_TIMEOUT_SEC    (1)
#define SMS_UNINITIALIZE_TIMEOUT_MSEC   (SMS_UNINITIALIZE_TIMEOUT_SEC * 1000)

// Maximum "Reasonable" Version Value Bit Width
#define SMS_MAX_BIT_WIDTH               ((size_t)32)

  /**************/
 /** TYPEDEFS **/
/**************/

/*
    SMS Control Object Structure
*/

typedef struct sms_behavior_configuration_struct
{
    BOOLEAN bAllowSelfTuneMature;
    BOOLEAN bRestoreFactoryDefaults;

} SMS_BEHAVIOR_CONFIGURATION_STRUCT;

typedef struct sms_dsm_attrs_struct
{
    // Data Service Control
    SMS_OBJECT hDSMCtrl;
    SMS_EVENT_HANDLER hDSMEventHandler;

    // System-wide device handle
    DEVICE_OBJECT hDevice;

} SMS_DSM_ATTRS_STRUCT;

typedef struct sms_control_object_struct
{
    // Flag to indicate initialization
    BOOLEAN bInitialized;

    // Our provisioned device group
    DEVICE_GROUP tDeviceGroup;
    BOOLEAN bDeviceGroupSet;

    // Linked list of SRMs
    OSAL_OBJECT_HDL hSRMList;

    // Configuration
    const char *pacConfigPath;
    const char *pacInitializerPath;
    const char *pacInitializerFile;
    TAG_OBJECT hTag;

    SONG_TAG_OBJECT hSongTag;

    SMS_BEHAVIOR_CONFIGURATION_STRUCT sBehaviors;

    SMS_DSM_ATTRS_STRUCT sDSM;

} SMS_CONTROL_OBJECT_STRUCT;

typedef struct sms_control_find_srm_struct
{
    const char *pacDriverName;
    const char *pacSRMName;

} SMS_CONTROL_FIND_SRM_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static const char *pacGetVersion (
    UN8 *pun8MajorVersion,
    UN8 *pun8MinorVersion,
    UN8 *pun8SubVersion
        );

static SMSAPI_RETURN_CODE_ENUM eInitialize (
    const char *pacConfigPath,
    const char *pacConfigInitializerPath,
    const char *pacConfigInitializerFile,
    BOOLEAN *pbConfigFileReset
        );

static SMSAPI_RETURN_CODE_ENUM eUninitialize ( void );

static SMSAPI_RETURN_CODE_ENUM eBehavior (
    SMS_BEHAVIOR_CODE eBehaviorCode,
    ...
        );

/* Object Private Prototypes */

static BOOLEAN bInitConfig ( BOOLEAN *pbConfigFileReset );

static void vUninitConfig ( void );

static N16 n16CompareHandles (
    void *pvObj1,
    void *pvObj2
        );

static N16 n16CompareNames (
    SRM_OBJECT hSRM,
    SMS_CONTROL_FIND_SRM_STRUCT *psFind
        );

static void vReleaseSRMs( void );

static BOOLEAN bReleaseSRMIterator (
    void *pvData,
    void *pvArg
        );

  /***************/
 /** VARIABLES **/
/***************/

SMS_CONTROL_OBJECT_STRUCT *gpsSms =
    (SMS_CONTROL_OBJECT_STRUCT *)NULL;

// Global (re-usable) instance of an interface for this object
const SMS_OBJECT_INTERFACE_STRUCT SMS =
{
    /*.pacGetVersion = */pacGetVersion,
    /*.eInitialize = */eInitialize,
    /*.eUninitialize = */eUninitialize,
    /*.eBehavior = */eBehavior

};

const SMS_BEHAVIOR_CONFIGURATION_STRUCT gsBehaviorDefault =
{
    /*.bAllowSelfTuneMature = */FALSE,
    /*.bRestoreFactoryDefaults = */FALSE

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SMS_H_
