/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _SHAPE_OBJ_H_
#define _SHAPE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"
#include "location_obj.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SHAPE_OBJECT_NAME "SHAPE"


  /**************/
 /** TYPEDEFS **/
/**************/

// GEO Point data
typedef struct geo_point_struct
{
    // Lat
    OSAL_FIXED_OBJECT hLat;
    OSAL_FIXED_OBJECT_DATA aLatData[OSAL_FIXED_OBJECT_SIZE];

    // Lon
    OSAL_FIXED_OBJECT hLon;
    OSAL_FIXED_OBJECT_DATA aLonData[OSAL_FIXED_OBJECT_SIZE];
} GEO_POINT_STRUCT;

// Private object structure
typedef struct shape_object_struct
{
    // Shape type
    SHAPE_TYPE_ENUM eType;

    // Number of points
    UN16 un16Points;

    // Array of location object
    GEO_POINT_STRUCT *pasPoints;
} SHAPE_OBJECT_STRUCT;

//Prototypes

static SHAPE_TYPE_ENUM eShapeType (
    SHAPE_OBJECT hShape
        );

static SMSAPI_RETURN_CODE_ENUM eIteratePoints (
    SHAPE_OBJECT hShape,
    SHAPE_POINTS_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
        );

static N32 n32FPrintf (
    SHAPE_OBJECT hWind,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static N32 n32GeoPointFPrintf (
    GEO_POINT_STRUCT *psObj,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutput
        );

static BOOLEAN bPointsArrayCreate (
    SHAPE_OBJECT_STRUCT *psObj
        );

static void vPointsArrayDestroy (
    SHAPE_OBJECT_STRUCT *psObj
        );

static GEO_POINT_STRUCT *psGeoPointCreateInMemory (
    N32 n32Lat,
    N32 n32Lon,
    GEO_POINT_STRUCT *psGeoPoint,
    UN8 un8FracBits
        );

static N32 n32GeoPointFPrintf (
    GEO_POINT_STRUCT *psObj,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutput
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const SHAPE_OBJECT_INTERFACE_STRUCT SHAPE = {
    /* eShapeType = */ eShapeType,
    /* eIteratePoints = */ eIteratePoints,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _WIND_OBJ_H_ */
