/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SEEK_H
#define _SEEK_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "seek.h"
#include "at_seek.h"
#include "tw_seek.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SEEK_OBJECT_NAME "SEEK"

// These definitions are used to represent a BOOLEAN value in text form.
#define SEEK_TRUE_TEXT              "TRUE"
#define SEEK_FALSE_TEXT             "FALSE"

// Default SEEK interface definition
static const SEEK_SERVICE_SPECIFIC_INTERFACE_STRUCT gsDefaultSeekInterface =
{
    /*.bInit = */NULL,
    /*.vUnInit = */NULL,
    /*.n32FPrintf = */NULL,
    /*.bHandleSeekAlert = */NULL,
};

extern const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsDefaultSeekContent;

// default specific seek service info structure
const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsDefaultSeek =
{
    /*.eService = */SEEK_SERVICE_INVALID,
    /*.psInterface = */&gsDefaultSeekInterface,
    /*.psContentInterface = */&GsDefaultSeekContent
};

// extern each defined specific service struct so they can be included in the
// mapping structure
extern const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsATSeek;
extern const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsTWSeek;
extern const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsSPSeek;

typedef struct seek_service_mapping_struct
{
    // The specific seek service information structure
    const SEEK_SERVICE_SPECIFIC_INFO_STRUCT *psInfo;

} SEEK_SERVICE_MAPPING_STRUCT;

// This mapping structure is used to get the specific seek service mapping
// stuctures for each specific seek service
static SEEK_SERVICE_MAPPING_STRUCT gasSeekServiceMap[] =
{
    {
        &GsATSeek
    }, // SEEK_SERVICE_ARTIST_TITLE
    {
        &GsTWSeek
    }, // SEEK_SERVICE_TRAFFIC_WEATHER
    {
        &GsSPSeek
    }, // SEEK_SERVICE_SPORTS
    {
        &GsDefaultSeek
    } // SEEK_SERVICE_INVALID

};


// Computes the number of type sof seek services we support
#define SEEK_NUM_SERVICES (sizeof(gasSeekServiceMap)/sizeof(SEEK_SERVICE_MAPPING_STRUCT))

#define SEEK_STATE "State"
  /**************/
 /** TYPEDEFS **/
/**************/

// Structure used for iterating the registered content
typedef struct seek_iterator_struct
{
    // Output stream
    FILE *psFile;

    // counter
    UN32 un32Count;

    // output option
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption;

    // number of bytes written
    N32 n32NumWritten;

} SEEK_ITERATOR_STRUCT;

// A structure used to iterate the seek object's cal
typedef struct seek_to_cal_iterator_struct
{
    void *pvSeekIteratorArg;

    SEEK_CONTENT_ITERATOR_CALLBACK bSeekIteratorCallback;

    SEEK_SERVICE_OBJECT hSeekService;

} SEEK_TO_CAL_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eStart (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static void vStop (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SMSAPI_RETURN_CODE_ENUM eEnable (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SMSAPI_RETURN_CODE_ENUM eDisable (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SEEK_STATE_ENUM eState (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static CATEGORY_ID tCategoryId (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

N32 n32FPrintf (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static 	size_t tNumItems (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SMSAPI_RETURN_CODE_ENUM eRemoveAll (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SMSAPI_RETURN_CODE_ENUM eIterate (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    SEEK_CONTENT_ITERATOR_CALLBACK bSeekContentIterator,
    void *pvSeekContentIteratorArg
        );

static SEEK_EVENT_OBJECT hGetNextEvent (
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM eGetNextEndedEventAttributes (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID *ptChannelId,
    STRING_OBJECT *phArtist,
    STRING_OBJECT *phTitle
        );

static BOOLEAN bGetAlertsTunedStatus (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SMSAPI_RETURN_CODE_ENUM eEnableAlertsTuned (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    BOOLEAN bEnable
        );

static BOOLEAN bGetAlertsFinishedStatus (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService
        );

static SMSAPI_RETURN_CODE_ENUM eEnableAlertsFinished (
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    BOOLEAN bEnable
        );

/* Object Private Prototypes */

static void vCalAlertCallback (
    CAL_OBJECT hCAL,
    CAL_ALERT_OBJECT hAlert,
    UN32 un32Flags,
    void *pvCALCallbackArg
        );

static BOOLEAN bSeekCalIterator (
    CAL_CONTENT_OBJECT hContent,
    void *pvContentIteratorArg
        );

static BOOLEAN bPrintContent (
    CAL_CONTENT_OBJECT hContent,
    void *pvContentIteratorArg
        );

static const char *pacSeekServiceText(
    SEEK_SERVICE_ENUM eType
        );

static const char *pacSeekStateText(
    SEEK_STATE_ENUM eState
        );

static BOOLEAN bRestoreServiceFromConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    DECODER_OBJECT hDecoder
        );

static BOOLEAN bUpdateStateTag(
    SEEK_SERVICE_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRemoveContentTagIterator(
    TAG_OBJECT hTag,
    void *pvArg
        );

  /***************/
 /** VARIABLES **/
/***************/


// Global instance of an interface for this object
const SEEK_INTERFACE_STRUCT SEEK =
{
    /*.eStart = */eStart,
    /*.vStop = */vStop,
    /*.eEnable = */eEnable,
    /*.eDisable = */eDisable,
    /*.eState = */eState,
    /*.tCategoryId = */tCategoryId,
    /*.n32FPrintf = */n32FPrintf,
    /*.tNumItems = */tNumItems,
    /*.eRemoveAll = */eRemoveAll,
    /*.eIterate = */eIterate,
    /*.hGetNextEvent = */hGetNextEvent,
    /*.eGetNextEndedEventAttributes = */eGetNextEndedEventAttributes,
    /*.bGetAlertsTunedStatus = */bGetAlertsTunedStatus,
    /*.eEnableAlertsTuned = */eEnableAlertsTuned,
    /*.bGetAlertsFinishedStatus = */bGetAlertsFinishedStatus,
    /*.eEnableAlertsFinished = */eEnableAlertsFinished
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SEEK_H
