/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SCACHE_H_
#define _SCACHE_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sms_update.h"
#include "sms_api.h"
#include "decoder_obj.h"
#include "playback_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SCACHE_OBJECT_NAME "SCACHE"

// 0x7FF is based on half of 0xFFF.
// The 0xFFF is based on 12 bits of relevant playback bits out of a 16bit id
// less 4bits for extraction index for SXi. Even though this was selected based
// on Sxi, it should work fine for most other implementations. There is not likely to
// be anywhere near 0x7FF songs in a buffer.
#define SONG_ID_ROLLOVER_MARGIN (0x7FF)

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct scache_object_struct
{
    // Song Cache Object Name
    char acName[OSAL_DEV_MAX_NAME_LENGTH_WITH_NULL];

    // Playback object this song cache belongs to
    PLAYBACK_OBJECT hPlayback;

    // Song list
    OSAL_OBJECT_HDL hSongList;

	// the tail of the LL
	OSAL_LINKED_LIST_ENTRY hTail;

	SONG_ID tCurrentSongID;

	// SCache Update Control Structure
    SMSU_EVENT_STRUCT sEvent;

} SCACHE_OBJECT_STRUCT;

// An scache song iterator shim structure
typedef struct scache_song_iterator_handler_struct
{
    SCACHE_SONG_ITERATOR_HANDLER bIterator;
    void *pvArg;

} SCACHE_SONG_ITERATOR_HANDLER_STRUCT;


  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */

static void vDeleteSong(
    void *pvData
        );

static N16 n16SongListCompareHandler(
    SONG_OBJECT hSong1,
    SONG_OBJECT hSong2
        );

static SONG_OBJECT hSongByID (
    SCACHE_OBJECT_STRUCT *psObj,
    SONG_ID tSong
        );

#if SMS_DEBUG == 1

static BOOLEAN bSongIterator (
    void *pvData,
    void *pvArg
        );

#endif

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SCACHE_H_
