/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _PLAYBACK_OBJ_H_
#define _PLAYBACK_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"
#include "radio.h"

#include "sms_task.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define PLAYBACK_OBJECT_NAME "PLAYBACK"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct playback_object_struct
{
    /* THINGS PROVIDED BY APPLICATION */

    // Decoder this object is attached to
    DECODER_OBJECT hDecoder;

    /* THINGS TO INITIALIZE ONCE */
    SCACHE_OBJECT hSCache;

    // A common LL of all SongList objects
    OSAL_OBJECT_HDL hSonglistLists;

    /* THINGS TO RE-INITIALIZE ON DEMAND */

    PLAYBACK_ERROR_CODE_ENUM eErrorCode;

    BOOLEAN bPaused;
    UN32 un32Duration;
    UN32 un32ElapsedTime;
    UN32 un32RemainingTime;

    UN32 un32WarningOffset;

    PLAYBACK_STATS_STRUCT sStats;

    PLAYBACK_OBJECT_EVENT_MASK tPlaybackEventMask;

} PLAYBACK_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static PLAYBACK_OBJECT_EVENT_MASK tEventMask (
    PLAYBACK_OBJECT hPlayback
        );

static SMSAPI_RETURN_CODE_ENUM ePause (
    PLAYBACK_OBJECT hPlayback
        );

static SMSAPI_RETURN_CODE_ENUM ePlay (
    PLAYBACK_OBJECT hPlayback
        );

static SMSAPI_RETURN_CODE_ENUM eSeekTime (
    PLAYBACK_OBJECT hPlayback,
    N32 n32Seconds,
    BOOLEAN bPauseAfterSeek
        );

static SMSAPI_RETURN_CODE_ENUM eSeekSong (
    PLAYBACK_OBJECT hPlayback,
    N16 n16RelativeOffset,
    BOOLEAN bPauseAfterSeek
        );

static SMSAPI_RETURN_CODE_ENUM eSeekDirect (
    PLAYBACK_OBJECT hPlayback,
    SONGLIST_OBJECT hSonglist,
    N16 n16Offset,
    BOOLEAN bPauseAfterSeek
        );

static SMSAPI_RETURN_CODE_ENUM eSeekPrevious (
    PLAYBACK_OBJECT hPlayback,
    BOOLEAN bPauseAfterSeek
        );

static SMSAPI_RETURN_CODE_ENUM eSeekNext (
    PLAYBACK_OBJECT hPlayback,
    BOOLEAN bPauseAfterSeek
        );

static SMSAPI_RETURN_CODE_ENUM ePlayPercentage (
    PLAYBACK_OBJECT hPlayback,
    UN8 *pun8PlayPercentage
        );

static SMSAPI_RETURN_CODE_ENUM eFillPercentage (
    PLAYBACK_OBJECT hPlayback,
    UN8 *pun8FillPercentage
        );

static SMSAPI_RETURN_CODE_ENUM eTimeOffset (
    PLAYBACK_OBJECT hPlayback,
    N32 *pn32TimeOffset
        );

static SMSAPI_RETURN_CODE_ENUM eTimeFromTrackStart (
    PLAYBACK_OBJECT hPlayback,
    UN32 *pun32TimeFromTrackStart
        );

static SMSAPI_RETURN_CODE_ENUM eTrackDuration (
    PLAYBACK_OBJECT hPlayback,
    UN32 *pun32Duration
        );

static SMSAPI_RETURN_CODE_ENUM eTracksBefore (
    PLAYBACK_OBJECT hPlayback,
    UN16 *pun16TracksBefore
        );

static SMSAPI_RETURN_CODE_ENUM eTracksRemaining (
    PLAYBACK_OBJECT hPlayback,
    UN16 *pun16TracksRemaining
        );

static SMSAPI_RETURN_CODE_ENUM eIsPaused (
    PLAYBACK_OBJECT hDecoder,
    BOOLEAN *pbPaused
        );

static PLAYBACK_ERROR_CODE_ENUM eErrorCode (
    PLAYBACK_OBJECT hPlayback
        );

static SMSAPI_RETURN_CODE_ENUM eWarningOffsetGet (
    PLAYBACK_OBJECT hPlayback,
    UN32 *pun32WarningOffset
        );

static SMSAPI_RETURN_CODE_ENUM eWarningOffsetSet (
    PLAYBACK_OBJECT hDecoder,
    UN32 un32WarningOffset
        );

static SMSAPI_RETURN_CODE_ENUM eRecordedContentTimeInfo (
    PLAYBACK_OBJECT hPlayback,
    UN32 *pun32Duration,
    UN32 *pun32ElapsedTime,
    UN32 *pun32RemainingTime
        );

static UN32 un32IRBufferDuration (
    PLAYBACK_OBJECT hPlayback
        );

/* Object Private Prototypes */

static void vUpdatePause (
    PLAYBACK_OBJECT_STRUCT *psObj,
    BOOLEAN bPaused
        );

// Global (re-usable) instance of an interface for this object
const PLAYBACK_OBJECT_INTERFACE_STRUCT PLAYBACK =
{
    // Public
    /*.ePause = */ePause,
    /*.ePlay = */ePlay,
    /*.eSeekTime = */eSeekTime,
    /*.eSeekSong = */eSeekSong,
    /*.eSeekDirect = */eSeekDirect,
    /*.ePlayPercentage = */ePlayPercentage,
    /*.eFillPercentage = */eFillPercentage,
    /*.eTimeOffset = */eTimeOffset,
    /*.eTimeFromTrackStart = */eTimeFromTrackStart,
    /*.eIsPaused = */eIsPaused,
    /*.tEventMask = */tEventMask,
    /*.eErrorCode = */eErrorCode,
    /*.eWarningOffsetGet = */eWarningOffsetGet,
    /*.eWarningOffsetSet = */eWarningOffsetSet,
    /*.eRecordedContentTimeInfo = */eRecordedContentTimeInfo,
    /*.un32IRBufferDuration = */un32IRBufferDuration,
    /*.eTrackDuration = */eTrackDuration,
    /*.eTracksBefore = */eTracksBefore,
    /*.eTracksRemaining = */eTracksRemaining,
    /*.eSeekPrevious = */eSeekPrevious,
    /*.eSeekNext = */eSeekNext

};
  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _PLAYBACK_OBJ_H_
