/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _PHONETICS_MGR_OBJ_H_
#define _PHONETICS_MGR_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "team_obj.h"
#include "sms_api.h"
#include "sms_update.h"
#include "cid_obj.h"
#include "dataservice_mgr_impl.h"
#include "sql_interface_obj.h"
#include "db_util.h"
#include "phonetics_interface.h"
#include "phonetics_db_constants.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define PHONETICS_MGR_OBJECT_NAME "PhoneticsService"

/* Phonetics Directory / File Names */
#define PHONETICS_TTS_DIR_NAME "tts"
#define PHONETICS_REC_DIR_NAME "rec"
#define PHONETICS_DEFAULT_FS_DELIM "/"

/* File name constants */
#define PHONETICS_CHANNEL_FILENAME "channels"
#define PHONETICS_CATEGORY_FILENAME "categories"
#define PHONETICS_MARKET_FILENAME "markets"
#define PHONETICS_TEAM_FILENAME "teams"
#define PHONETICS_LEAGUE_FILENAME "leagues"
#define PHONETICS_ENGLISH_FILE "_eng"
#define PHONETICS_SPANISH_FILE "_esp"
#define PHONETICS_FRENCH_FILE "_fr"
#define PHONETICS_FILE_EXTENSION ".dic"

/* Table ID constants */
#define PHONETICS_CHAN_TABLE_ID (0)
#define PHONETICS_CAT_TABLE_ID (1)
#define PHONETICS_MARKET_TABLE_ID (2)
#define PHONETICS_TEAM_TABLE_ID (3)
#define PHONETICS_LEAGUE_TABLE_ID (4)
#define PHONETICS_NUM_TABLES (5)

/* General */
#define PHONETICS_FILE_MODE "wb"
#define PHONETICS_DELIMITER_STRING "|"
#define PHONETICS_MAX_ID_CHAR_LEN (12)

#define PHONETICS_SUPPORTED_OPTIONS (     \
    (DATASERVICE_OPTIONS_MASK)            \
    DATASERVICE_OPTION_REFERENCE_DB_PATH  \
        )

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct phonetics_table_ver_struct
{
    UN8 un8TableDefVer;
    UN16 un16TableContentVer;

} PHONETICS_TABLE_VER_STRUCT;

typedef struct phonetics_ver_ctrl_struct
{
    PHONETICS_TABLE_VER_STRUCT asTableVer[PHONETICS_NUM_TABLES];

} PHONETICS_VER_CTRL_STRUCT;

typedef union phonetics_cid_creator_union
{
    MARKET_CID_CREATOR hMarketCreator;

} PHONETICS_CID_CREATOR_UNION;

typedef struct phonetics_file_output_struct
{
    SMS_LANGUAGE_ENUM eLanguage;

    // TTS file related
    STRING_OBJECT hTTSFilePath;
    FILE *psTTSFile;

    // Rec file related
    STRING_OBJECT hRecFilePath;
    FILE *psRecFile;

    BOOLEAN bDataPresentInFiles;

} PHONETICS_FILE_OUTPUT_STRUCT;

typedef struct phonetics_work_unit_struct
{
    // The type of data to process
    PHONETICS_FILE_TYPE_ENUM eType;
    CID_POOL hCidPool;
    PHONETICS_CID_CREATOR_UNION uCidCreator;

    // The data to process
    OSAL_OBJECT_HDL hListData;

    // The query to use on the reference database
    const char *pacSQLQuery;

    // The array of file output structures needed
    PHONETICS_FILE_OUTPUT_STRUCT asFiles[PHONETICS_MAX_LANGUAGES];

    // Table info to use when updating the persistent db
    PHONETICS_DB_VERSION_TYPES_ENUM eDefVersion;
    PHONETICS_DB_VERSION_TYPES_ENUM eContentVersion;
    UN8 un8PhoneticsFileVer;
    UN16 un16PhoneticsContentVer;

} PHONETICS_WORK_UNIT_STRUCT;

/* Private object elements */
typedef struct phonetics_mgr_object_struct
{
    // Application Update Control Structure
    SMSU_EVENT_STRUCT sEvent;

    // Interface handle
    PHONETICS_INTERFACE_OBJECT hInterface;

    // DB Connection Handles
    SQL_INTERFACE_OBJECT hSQLRefConnection;
    SQL_INTERFACE_OBJECT hSQLPersistConnection;
    char *pacRefDatabaseDirPath;

    // Output Directories for phonetics
    STRING_OBJECT hTTSOutputDir;
    STRING_OBJECT hRecOutputDir;

    // File update reporting attributes
    PHONETICS_FILE_UPDATE_CALLBACK vFileCallback;
    void *pvFileCallbackArg;

    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit;

} PHONETICS_MGR_OBJECT_STRUCT;

typedef struct phonetics_db_version_result_struct
{
    PHONETICS_VER_CTRL_STRUCT *psVerCtrl;
    BOOLEAN bSuccess;

} PHONETICS_DB_VERSION_RESULT_STRUCT;

typedef struct phonetics_db_process_struct
{
    OSAL_LINKED_LIST_ENTRY hEntry;
    PHONETICS_LIST_NODE_STRUCT *psEntry;
    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit;
    BOOLEAN bSuccess;

} PHONETICS_DB_PROCESS_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static PHONETICS_SERVICE_OBJECT hStart (
    const char *pacSRHDriverName,
    const char *pacOutputDir,
    DATASERVICE_EVENT_MASK tEventRequestMask,
    DATASERVICE_EVENT_CALLBACK vEventCallback,
    void *pvEventCallbackArg,
    PHONETICS_FILE_UPDATE_CALLBACK vFileCallback,
    void *pvFileCallbackArg,
    DATASERVICE_OPTIONS_STRUCT const *psOptions
        );

static BOOLEAN bGenerateDistributionFiles (
    const char *pacTTSOutputDir,
    const char *pacRecOutputDir,
    const char *pacDBPath
        );

SERVICE_ID tReadServiceIdFromDictionary (
    FILE *psDictionaryFile
        );

CATEGORY_ID tReadCategoryIdFromDictionary (
    FILE *psDictionaryFile
        );

/* Object Private Prototypes */

/* Interface functions */

static BOOLEAN bNewList (
    PHONETICS_SERVICE_OBJECT hPhoneticsService,
    PHONETICS_FILE_TYPE_ENUM eType,
    UN8 un8PhoneticsFileVer,
    UN16 un16PhoneticsContentVer,
    OSAL_OBJECT_HDL hPhoneticsList
        );

static PHONETICS_FILE_TYPE_ENUM eTypeForId (
    UN8 un8TableId
        );

static OSAL_OBJECT_HDL hCreatePhoneticsList (
    PHONETICS_FILE_TYPE_ENUM eType
        );

static BOOLEAN bConcatPhoneticData (
    STRING_OBJECT hAggregate,
    STRING_OBJECT hNewPhonetics
        );

static N16 n16ComparePhoneticNode (
    PHONETICS_LIST_NODE_STRUCT *psNode1,
    PHONETICS_LIST_NODE_STRUCT *psNode2
        );

static BOOLEAN bRemovePhoneticNode (
    PHONETICS_LIST_NODE_STRUCT *psNode,
    void *pvUnused
        );

static char const *pacFileType (
    PHONETICS_FILE_TYPE_ENUM eType
        );

/* Event handling */
static void vEventHandler (
    DATASERVICE_MGR_OBJECT hDataService,
    DATASERVICE_EVENT_MASK tCurrentEvent,
    void *pvEventArg,
    void *pvEventCallbackArg
        );

static BOOLEAN bHandleServiceReady (
    PHONETICS_MGR_OBJECT_STRUCT *psObj
        );

static BOOLEAN bConnectToInterface (
    PHONETICS_MGR_OBJECT_STRUCT *psObj,
    size_t tNumTables,
    PHONETICS_VER_CTRL_STRUCT const *psTableVersions
        );

static void vUninitObject (
    PHONETICS_MGR_OBJECT_STRUCT *psObj,
    BOOLEAN bFullDelete
        );

static void vDestroyObject(
    PHONETICS_MGR_OBJECT_STRUCT *psObj
        );

/* General Functions */

static BOOLEAN bPrepareOutputDirectories (
    PHONETICS_MGR_OBJECT_STRUCT *psObj,
    const char *pacOutputDir
        );

static STRING_OBJECT hCreateOutputDir (
    const char *pacOutputDir
        );

static BOOLEAN bReadIdFromFile (
    UN32 *pun32Id,
    FILE *psFile
        );

static BOOLEAN bHandleNewPhoneticsList (
    PHONETICS_MGR_OBJECT_STRUCT *psObj
        );

static BOOLEAN bNewListLocal (
    PHONETICS_SERVICE_OBJECT hPhoneticsService,
    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit,
    STRING_OBJECT hTTSOutputDir,
    STRING_OBJECT hRecOutputDir
        );

static BOOLEAN bCreateFilePaths (
    PHONETICS_SERVICE_OBJECT hPhoneticsService,
    const char *pacFilename,
    STRING_OBJECT hTTSOutputDir,
    STRING_OBJECT hRecOutputDir,
    PHONETICS_FILE_OUTPUT_STRUCT *psFiles
        );

static void vDestroyFilePaths (
    PHONETICS_FILE_OUTPUT_STRUCT *psFiles
        );

static BOOLEAN bOpenOutputFiles (
    PHONETICS_FILE_OUTPUT_STRUCT *psFiles
        );

static void vCloseOutputFiles (
    PHONETICS_FILE_OUTPUT_STRUCT *psFiles
        );

static BOOLEAN bProcessNewPhoneticsList (
    SQL_INTERFACE_OBJECT hRefDBConnection,
    SQL_INTERFACE_OBJECT hPersistDBConnection,
    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit
        );

static PHONETICS_WORK_UNIT_STRUCT *psCreateWorkUnit (
    PHONETICS_MGR_OBJECT_STRUCT *psObj,
    UN8 un8PhoneticsFileVer,
    UN16 un16PhoneticsContentVer,
    PHONETICS_FILE_TYPE_ENUM eType,
    OSAL_OBJECT_HDL hPhoneticsList
        );

static void vClearWorkUnit (
    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit
        );

static N16 n16CompareRowToNode (
    PHONETICS_PHONETIC_ROW_STRUCT *psDBRow,
    PHONETICS_LIST_NODE_STRUCT *psNode
        );

static BOOLEAN bWritePhoneticsRowByLanguage (
    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit,
    PHONETICS_PHONETIC_ID_STRUCT *psID,
    PHONETICS_LIST_NODE_STRUCT *psOTAPhonetics,
    PHONETICS_PHONETIC_ROW_STRUCT *psDBPhonetics
        );

static BOOLEAN bWritePhoneticsRow (
    PHONETICS_WORK_UNIT_STRUCT *psWorkUnit,
    PHONETICS_PHONETIC_ID_STRUCT *psID,
    const char *pacDBPhonetics,
    STRING_OBJECT hNewPhonetics,
    PHONETICS_FILE_OUTPUT_STRUCT *psOutputFiles
        );

static BOOLEAN bWriteSvcCatID (
    UN32 un32Id,
    BOOLEAN bCategory,
    PHONETICS_FILE_OUTPUT_STRUCT *psOutputFiles
        );

static BOOLEAN bWriteMarketID (
    CID_POOL hCidPool,
    MARKET_CID_CREATOR hMarketCreator,
    UN32 un32Id,
    PHONETICS_FILE_OUTPUT_STRUCT *psOutputFiles
        );

static BOOLEAN bWriteLeagueID (
    CID_POOL hCidPool,
    UN32 un32Id,
    PHONETICS_FILE_OUTPUT_STRUCT *psOutputFiles
        );

static BOOLEAN bWriteTeamID(
    CID_POOL hCidPool,
    UN32 un32TeamId,
    UN8 un8NumLeagues,
    UN16 *pun16Leagues,
    PHONETICS_FILE_OUTPUT_STRUCT *psOutputFiles
        );

static BOOLEAN bWritePhoneticsString (
    STRING_OBJECT hNewPhonetics,
    const char *pacDBPhonetics,
    PHONETICS_FILE_OUTPUT_STRUCT *psOutputFiles
        );

static void vSetError (
    PHONETICS_MGR_OBJECT_STRUCT *psObj,
    DATASERVICE_ERROR_CODE_ENUM eErrorCode
        );

#ifdef PHONETICS_TEST
static BOOLEAN bInsertTestData (
    OSAL_OBJECT_HDL *phListHandle
        );
#endif

/* DB Access functions */

static BOOLEAN bCreatePersistDBTables (
    SQL_INTERFACE_OBJECT hSQLConnection,
    PHONETICS_VER_CTRL_STRUCT *psVerCtrl
        );

static BOOLEAN bVerifyAndLoadDBVersionFields (
    SQL_INTERFACE_OBJECT hSQLConnection,
    PHONETICS_VER_CTRL_STRUCT *psVerCtrl
        );

static BOOLEAN bProcessSelectVersion (
    SQL_QUERY_COLUMN_STRUCT *psColumn,
    N32 n32NumberOfColumns,
    PHONETICS_DB_VERSION_RESULT_STRUCT *psResult
        );

static BOOLEAN bProcessSelectPhonetics (
    SQL_QUERY_COLUMN_STRUCT *psColumn,
    N32 n32NumberOfColumns,
    PHONETICS_DB_PROCESS_STRUCT *psProcess
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const PHONETICS_INTERFACE_STRUCT PHONETICS =
{
    /*.hStart = */                       hStart,
    /*.vStop = */                        (void (*) (PHONETICS_SERVICE_OBJECT hPhoneticsService))DATASERVICE_IMPL_vStop,
    /*.bGenerateDistributionFiles = */   bGenerateDistributionFiles,
    /*.tReadServiceIdFromDictionary = */ tReadServiceIdFromDictionary,
    /*.tReadCategoryIdFromDictionary = */tReadCategoryIdFromDictionary,
    /*.eState = */                       (DATASERVICE_STATE_ENUM (*) (PHONETICS_SERVICE_OBJECT hPhoneticsService))DATASERVICE_IMPL_eState,
    /*.eErrorCode = */                   (DATASERVICE_ERROR_CODE_ENUM (*) (PHONETICS_SERVICE_OBJECT hPhoneticsService))DATASERVICE_IMPL_eErrorCode
};

// Manager interface for plugins
const PHONETICS_MGR_INTERFACE_STRUCT GsPhoneticsMgrIntf =
{
    /*.bNewList = */              bNewList,
    /*.eTypeForId = */            eTypeForId,
    /*.hCreatePhoneticsList = */  hCreatePhoneticsList,
    /*.bConcatPhoneticData = */   bConcatPhoneticData,
    /*.n16CompareNode = */        n16ComparePhoneticNode,
    /*.bRemoveNode = */           bRemovePhoneticNode,
    /*.pacFileType = */           pacFileType
};

const DATASERVICE_STATE_HANDLERS_STRUCT GsPhoneticsStateHandlers =
{
    /*.bHandleServiceReady = */(DATASERVICE_STATE_HANDLER)bHandleServiceReady,
    /*.bHandleServiceStopped = */DATASERVICE_IMPL_bGenericStateHandler,
    /*.bHandleServiceError = */DATASERVICE_IMPL_bGenericStateHandler
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _PHONETICS_MGR_OBJ_H_
