/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _MOVIE_OBJ_H_
#define _MOVIE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "movie_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define MOVIE_OBJECT_NAME "MOVIE"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct movie_multi_lang_string_struct
{
    SMS_LANGUAGE_ENUM eLanguage;
    STRING_OBJECT hValue;

} MOVIE_MULTI_LANG_STRING_STRUCT;

typedef struct movie_object_struct
{
    MOVIE_ID tID;
    MOVIE_MULTI_LANG_FIELD_STRUCT sName;
    UN8 un8RunTime;
    STRING_OBJECT hActors;
    MOVIE_MULTI_LANG_FIELD_STRUCT sSynopsis;

    // Linked list of ratings for movie
    OSAL_OBJECT_HDL hRatings;

    // Direct link to the US-MPAA rating entry
    MOVIE_RATING_STRUCT *psUSMPAA;

    // Exception data
    BOOLEAN bExceptionActive;
    MOVIE_RATING_SYSTEM_ENUM eRatingExceptionSystem;
    MOVIE_RATING_ENUM eRatingException;
    STRING_OBJECT hRatingExceptionText;

} MOVIE_OBJECT_STRUCT;

typedef struct movie_rating_to_text_entry_struct
{
    MOVIE_RATING_SYSTEM_ENUM eRatingSystem;
    MOVIE_RATING_ENUM eRating;
    const char *pcRatingText;

} MOVIE_RATING_TO_TEXT_ENTRY_STRUCT;

typedef struct movie_rating_iterator_struct
{
    MOVIE_OBJECT_STRUCT *psObj;
    MOVIE_RATINGS_ITERATOR bIterator;
    void *pvIteratorArg;

} MOVIE_RATING_ITERATOR_STRUCT;

typedef struct movie_rating_print_struct
{
    FILE *psFile;
    N32 n32NumCharsWritten;

} MOVIE_RATING_PRINT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static MOVIE_ID tID (
    MOVIE_OBJECT hMovie
        );

static STRING_OBJECT hName (
    MOVIE_OBJECT hMovie
        );

static STRING_OBJECT hNameInLanguage (
    MOVIE_OBJECT hMovie,
    SMS_LANGUAGE_ENUM *peLanguage
        );

static UN8 un8RunTime (
    MOVIE_OBJECT hMovie
        );

static STRING_OBJECT hActors (
    MOVIE_OBJECT hMovie
        );

static STRING_OBJECT hSynopsis (
    MOVIE_OBJECT hMovie
        );

static STRING_OBJECT hSynopsisInLanguage (
    MOVIE_OBJECT hMovie,
    SMS_LANGUAGE_ENUM *peLanguage
        );

static MOVIE_RATING_ENUM eRating (
    MOVIE_OBJECT hMovie
        );

static STRING_OBJECT hRatingText (
    MOVIE_OBJECT hMovie
        );

static SMSAPI_RETURN_CODE_ENUM eIterateRatings (
    MOVIE_OBJECT hMovie,
    MOVIE_RATINGS_ITERATOR bIterator,
    void *pvIteratorArg
        );

static N32 n32FPrintf (
    MOVIE_OBJECT hMovie,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Object Private Prototypes */

static const char *pacRatingSysEnumToString (
    MOVIE_RATING_SYSTEM_ENUM eRatingSys
        );

static const char *pacRatingEnumToString (
    MOVIE_RATING_ENUM eRating
        );

static BOOLEAN bIterateRatings (
    MOVIE_RATING_STRUCT *psRating,
    MOVIE_RATING_ITERATOR_STRUCT *psIterator
        );

static N16 n16CompareRatingEntries (
    MOVIE_RATING_STRUCT *psRating1,
    MOVIE_RATING_STRUCT *psRating2
        );

static BOOLEAN bPrintRatingEntry (
    MOVIE_RATING_SYSTEM_ENUM eRatingSystem,
    STRING_OBJECT hRatingSystemName,
    MOVIE_RATING_ENUM eRating,
    STRING_OBJECT hRatingText,
    MOVIE_RATING_PRINT_STRUCT *psPrint
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const MOVIE_OBJECT_INTERFACE_STRUCT MOVIE =
{
    /*.tID = */tID,
    /*.hName = */hName,
    /*.hNameInLanguage = */hNameInLanguage,
    /*.un8RunTime = */un8RunTime,
    /*.hActors = */hActors,
    /*.hSynopsis = */hSynopsis,
    /*.hSynopsisInLanguage = */hSynopsisInLanguage,
    /*.eRating = */eRating,
    /*.hRatingText = */hRatingText,
    /*.eIterateRatings = */eIterateRatings,
    /*.n32FPrintf = */n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _MOVIE_OBJ_H_
