/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _LOCALIZATION_OBJ_H_
#define _LOCALIZATION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "srm_obj.h"
#include "sms_update.h"
#include "dataservice_mgr_obj.h"
#include "dataservice_base.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define LOCALIZATION_OBJECT_NAME "LOCALIZATION"

/* Default localization */
#define LOCALIZATION_DEFAULT (LOCALIZATION_MEASUREMENT_SYSTEM_US)

  /**************/
 /** TYPEDEFS **/
/**************/

// describes single measurement system
typedef struct localization_item_struct {
    // Measurement system described by the item
    LOCALIZATION_MEASUREMENT_SYSTEM_ENUM eSystem;

    // Temperature unit
    LOCALIZATION_MEASUREMENT_UNITS_ENUM eTemperature;

    // Snow range unit
    LOCALIZATION_MEASUREMENT_UNITS_ENUM eDistance;

    // Wind speed unit
    LOCALIZATION_MEASUREMENT_UNITS_ENUM eSpeed;

    // Precipitation amount unit
    LOCALIZATION_MEASUREMENT_UNITS_ENUM ePrecipAmount;
} LOCALIZATION_ITEM_STRUCT;

typedef struct localization_object_struct {

    // Current localization system
    LOCALIZATION_MEASUREMENT_SYSTEM_ENUM eSystem;

    // Keeps current measurement system values
    const LOCALIZATION_ITEM_STRUCT *psCurrentLocal;

    // Keeps default measurement system values
    const LOCALIZATION_ITEM_STRUCT *psDefaultLocal;

} LOCALIZATION_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static BOOLEAN bSetMeasurementSystem (
    LOCALIZATION_MEASUREMENT_SYSTEM_ENUM eMeasureSystem
        );

static LOCALIZATION_MEASUREMENT_UNITS_ENUM eGetTemperatureUnits ( void );
static LOCALIZATION_MEASUREMENT_UNITS_ENUM eGetDistanceUnits ( void );
static LOCALIZATION_MEASUREMENT_UNITS_ENUM eGetSpeedUnits ( void );
static LOCALIZATION_MEASUREMENT_UNITS_ENUM eGetPrecipitationUnits ( void );
static SMS_LANGUAGE_ENUM eGetLanguage ( void );

/* Object Private Prototypes */
static SMSAPI_RETURN_CODE_ENUM eInitialize( void );

static const LOCALIZATION_ITEM_STRUCT *psFindLocalization(
    LOCALIZATION_MEASUREMENT_SYSTEM_ENUM eMeasureSystem
        );

static const LOCALIZATION_ITEM_STRUCT *psGetCurrentLocalization( void );
static const LOCALIZATION_ITEM_STRUCT *psGetDefaultLocalization( void );

  /***************/
 /** VARIABLES **/
/***************/

// Measurement system storage
static const LOCALIZATION_ITEM_STRUCT GsLocalizationList[] = {
    {
        /* eSystem = */       LOCALIZATION_MEASUREMENT_SYSTEM_US,
        /* eTemperature = */  LOCALIZATION_MEASUREMENT_UNITS_FAHRENHEIT,
        /* eDistance = */     LOCALIZATION_MEASUREMENT_UNITS_INCH,
        /* eSpeed = */        LOCALIZATION_MEASUREMENT_UNITS_MILES_PER_HOUR,
        /* ePrecipAmount = */ LOCALIZATION_MEASUREMENT_UNITS_INCH
    }
};

// Localization single instance
static LOCALIZATION_OBJECT_STRUCT *GpsLocalization = NULL;

// Global (re-usable) instance of an interface for this object
const LOCALIZATION_OBJECT_INTERFACE_STRUCT LOCALIZATION = {
    /* bSetMeasurementSystem = */   bSetMeasurementSystem,
    /* eGetTemperatureUnits = */    eGetTemperatureUnits,
    /* eGetDistanceUnits = */       eGetDistanceUnits,
    /* eGetSpeedUnits = */          eGetSpeedUnits,
    /* eGetPrecipitationUnits = */  eGetPrecipitationUnits,
    /* eGetLanguage = */            eGetLanguage
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/
#endif  // _LOCALIZATION_OBJ_H_
