/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _LINK_STATUS_INFORMATION_OBJ_H_
#define _LINK_STATUS_INFORMATION_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "decoder_obj.h"
#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define LINK_STATUS_INFORMATION_OBJECT_NAME "LINK_STATUS_INFORMATION"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct link_status_information_object_struct
{
    NUMBER_CONFIRMATION_TIMEOUTS tNumberConfirmationTimeouts;
    PACKET_COUNTER_NUMBER tNumberDataPacketsDropped;
    PACKET_COUNTER_NUMBER tNumberDataPacketsTransmitted;
    PACKET_COUNTER_NUMBER tNumberAudioPacketsDropped;
    PACKET_COUNTER_NUMBER tNumberAudioPacketsTransmitted;

} LINK_STATUS_INFORMATION_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Members */
static SMSAPI_RETURN_CODE_ENUM eNumberConfirmationTimeouts (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    NUMBER_CONFIRMATION_TIMEOUTS *ptNumConfirmTimeouts
        );

static SMSAPI_RETURN_CODE_ENUM eNumberDataPacketsDropped (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptDataPacketsDropped
        );

static SMSAPI_RETURN_CODE_ENUM eNumberDataPacketsTransmitted (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptDataPacketsTransmitted
        );

static SMSAPI_RETURN_CODE_ENUM eNumberAudioPacketsDropped (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptAudioPacketsDropped
        );

static SMSAPI_RETURN_CODE_ENUM eNumberAudioPacketsTransmitted (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    PACKET_COUNTER_NUMBER *ptAudioPacketsTransmitted
        );

static N32 n32FPrintf (
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInfo,
    FILE *psFile
        );

/* Object Public Prototypes */
static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromDecoder(
    DECODER_OBJECT hDecoder,
    LINK_STATUS_INFORMATION_OBJECT_STRUCT **ppsObj
        );

  /***************/
 /** VARIABLES **/
/***************/

// Link Status Information Object Defaults
static const LINK_STATUS_INFORMATION_OBJECT_STRUCT gsObjectDefaults =
{
    //All data values are initialized to zero
	0,
	0,
	0,
	0,
	0
};


// Global (re-usable) instance of an interface for this object
const LINK_STATUS_INFORMATION_OBJECT_INTERFACE_STRUCT LINK_STATUS_INFORMATION =
{
    /* Object Members */
    /*.hNumberConfirmationTimeouts = */eNumberConfirmationTimeouts,
    /*.eNumberDataPacketsDropped = */eNumberDataPacketsDropped,
    /*.eNumberDataPacketsTransmitted= */eNumberDataPacketsTransmitted,
    /*.eNumberAudioPacketsDropped= */eNumberAudioPacketsDropped,
    /*.eNumberAudioPacketsTransmitted = */eNumberAudioPacketsTransmitted,
    /*.n32FPrintf =*/n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _LINK_STATUS_INFORMATION
