/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
* DESCRIPTION
*
* PRIVATE HEADER
*
******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _LEAGUE_TEAM_ID_H_
#define _LEAGUE_TEAM_ID_H_

/**************/
/** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "cid_obj.h"

/***************/
/** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/**************/
/** TYPEDEFS **/
/**************/

typedef struct cid_league_team_id_object * CID_LEAGUE_TEAM_ID_OBJECT;
#define CID_LEAGUE_TEAM_ID_INVALID_OBJECT (CID_LEAGUE_TEAM_ID_OBJECT)NULL

/************/
/** MACROS **/
/************/

/****************/
/** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static const void *pvCreate (
    const void *pvSrcObjectData,
    size_t tMinimumSize,
    SMS_OBJECT hParent,
    BOOLEAN bConstant
    );

static void vDestroy (
    const void *pvObject
    );

static const void *pvDuplicate (
    const void *pvObject
    );

static BOOLEAN bModify (
    const void **ppvObject,
    const void *pvSrcObjectData
    );

static BOOLEAN bCopy (
    void **ppvDstObject,
    const void *pvSrcObject
    );

static size_t tSize(
    const void *pvObject
    );

static N16 n16Compare (
    const void *pvObject1,
    const void *pvObject2,
    BOOLEAN bBinary
    );

static N32 n32FWrite (
    const void *pvObject,
    FILE *psFile
    );

static N32 n32FWriteToMemory (
    const void *pvObject,
    void **ppvMemory
    );

static const void *pvRead (
    FILE *psFile
    );

static BOOLEAN bReadFromMemory(
    const void **ppvObjectData,
    void **ppvMemory,
    SMS_OBJECT hParent
    );

static N32 n32FPrintf (
    const void *pvObject,
    FILE *psFile
    );

static N32 n32GetValue (
    const void *pvObject,
    void **ppvValue
    );

static BOOLEAN bParse (
    CD_OBJECT hCDO,
    const void *pvData
    );

/* Object Private Prototypes */

/***************/
/** VARIABLES **/
/***************/

// Global structure defining the CID Interface for TEAM ID
// Also note that the TEAM ID object data is a set of CIDs and thus
// we borrow the CID interface APIs.
const CID_TYPE_INTERFACE_STRUCT GsLeagueTeamIdIntf =
{
    // CID type
    /*.eType = */CID_LEAGUE_TEAM_ID,

    // Init/Unit methods
    /*.bInitialize = */NULL,
    /*.vUnInitialize = */NULL,

    // CID Input Data Parse Method
    /*.bParse = */bParse,

    // Object Data Methods
    /*.sObjData = */{

        // Minimum Expected Size (if known, otherwise 0)
        /*.tMinSize = */0,
            // Object Data Create/Destroy Methods
            /*.pvCreate = */pvCreate,
            /*.vDestroy = */vDestroy,

            // Object Data Manipulation Methods
            /*.pvDuplicate = */pvDuplicate,
            /*.bModify = */bModify,
            /*.bCopy = */bCopy,
            /*.tSize = */tSize,
            /*.n16Compare = */n16Compare,

            // Object Data I/O Methods
            /*.n32FWrite = */n32FWrite,
            /*.n32FWriteToMemory = */n32FWriteToMemory,
            /*.pvRead = */pvRead,
            /*.bReadFromMemory = */bReadFromMemory,
            /*.n32FPrintf = */n32FPrintf,
            /*.n32GetValue = */n32GetValue
    }

};

/**********************/
/** INLINE FUNCTIONS **/
/**********************/

#endif	// _LEAGUE_TEAM_ID_H_
