/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _FORECAST_OBJ_H_
#define _FORECAST_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>
#include <time.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "weather_interface.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define FORECAST_OBJECT_NAME "FORECAST"

  /**************/
 /** TYPEDEFS **/
/**************/

// Private object structure
typedef struct forecast_object_struct
{
	FORECAST_DATA_STRUCT sData;
	UN32 un32TimeStamp;
	WEATHER_EVENT_OBJECT hWeatherEvent;
	TEMPERATURE_OBJECT hTemperature;
	WIND_OBJECT hWind;
	PRECIPITATION_OBJECT hPrecipitation;
	HUMIDITY_OBJECT hHumidity;
	UVINFO_OBJECT hUVInfo;
	AIR_OBJECT hAir;
} FORECAST_OBJECT_STRUCT;

static UN32 gun32ForecastCounter = 0;

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eWeatherEvent (
	FORECAST_OBJECT hForecast,
	WEATHER_EVENT_OBJECT *phWeatherEvent
        );

static SMSAPI_RETURN_CODE_ENUM eTemperature (
	FORECAST_OBJECT hForecast,
	TEMPERATURE_OBJECT *phTemperature
        );

static SMSAPI_RETURN_CODE_ENUM ePrecipitation (
	FORECAST_OBJECT hForecast,
	PRECIPITATION_OBJECT *phPrecipitation
        );

static SMSAPI_RETURN_CODE_ENUM eWind (
	FORECAST_OBJECT hForecast,
	WIND_OBJECT *phWind
        );

static SMSAPI_RETURN_CODE_ENUM eHumidity (
	FORECAST_OBJECT hForecast,
	HUMIDITY_OBJECT *phHumidity
        );

static SMSAPI_RETURN_CODE_ENUM eUVInfo (
	FORECAST_OBJECT hForecast,
	UVINFO_OBJECT *phUVInfo
        );

static SMSAPI_RETURN_CODE_ENUM eAir (
	FORECAST_OBJECT hForecast,
	AIR_OBJECT *phAir
        );

static SMSAPI_RETURN_CODE_ENUM eCloudCover (
	FORECAST_OBJECT hForecast,
	FORECAST_CLOUD_COVER_ENUM *peCloudCover
        );

static UN32 un32TimeStamp (
	FORECAST_OBJECT hForecast
        );

static N32 n32FPrintf (
	FORECAST_OBJECT hForecast,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Object Private Prototypes */

static void vDestroy(FORECAST_OBJECT_STRUCT *psObj);

static const char *pacCloudCover (
    FORECAST_CLOUD_COVER_ENUM eCloudCover
        );

// Global (re-usable) instance of an interface for this object
const FORECAST_OBJECT_INTERFACE_STRUCT FORECAST =
{
	/*.eWeatherEvent = */eWeatherEvent,
	/*.eTemperature = */eTemperature,
	/*.ePrecipitation = */ePrecipitation,
	/*.eWind = */eWind,
	/*.eHumidity = */eHumidity,
	/*.eUVInfo = */eUVInfo,
	/*.eAir = */eAir,
	/*.eCloudCover = */eCloudCover,
	/*.un32TimeStamp = */un32TimeStamp,
	/*.n32FPrintf = */n32FPrintf
};


  /***************/
 /** VARIABLES **/
/***************/



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/
#endif    // _FORECAST_OBJ_H_
