/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _EPG_TOPIC_OBJ_H_
#define _EPG_TOPIC_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <standard.h>

#include "sms_api.h"
#include "epg_topic_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define EPG_TOPIC_DBG_PREFIX    "EPG TOPIC"

/* Object name prefix for objects */
#define EPG_TOPIC_OBJECT_NAME   "EPG:Topic"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static TOPIC_ID tTopicId(TOPIC_OBJECT hEpgTopic);

static STRING_OBJECT hTopicName(TOPIC_OBJECT hEpgTopic);

static N32 n32FPrintf(TOPIC_OBJECT hEpgTopic, FILE *psFile);

  /***************/
 /** VARIABLES **/
/***************/

/* Global (re-usable) instance of an interface for this object */
const EPG_TOPIC_INTERFACE_STRUCT TOPIC =
{
 /*tTopicId =*/ tTopicId,
 /*hTopicName =*/ hTopicName,
 /*n32FPrintf =*/ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _EPG_TOPIC_OBJ_H_
