/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _ENGINEERING_DATA_OBJ_H_
#define _ENGINEERING_DATA_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "sms_update.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define ENGINEERING_DATA_OBJECT_NAME "ENGINEERING_DATA"

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct engineering_data_object_struct
{
    DETAILED_SIGNAL_QUALITY_OBJECT hSignalQualityDetailed;
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hOverlaySignalQualityDetailed;
    LINK_STATUS_INFORMATION_OBJECT hLinkStatusInformation;
    AUDIO_DECODER_BITRATE tBitrate;

    // Decoder Update Control Structure
    SMSU_EVENT_STRUCT sEvent;

} ENGINEERING_DATA_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static ENGINEERING_DATA_EVENT_MASK tEventMask(
    DECODER_OBJECT hDecoder
        );

static DETAILED_SIGNAL_QUALITY_OBJECT hSignalQualityDetailed(
    DECODER_OBJECT hDecoder
        );

static DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hOverlaySignalQualityDetailed(
    DECODER_OBJECT hDecoder
        );

static SMSAPI_RETURN_CODE_ENUM eAudioDecoderBitrate(
    DECODER_OBJECT hDecoder,
    AUDIO_DECODER_BITRATE *ptBitrate
        );

static LINK_STATUS_INFORMATION_OBJECT hLinkStatusInformation(
    DECODER_OBJECT hDecoder
        );

static N32 n32FPrintf(
    DECODER_OBJECT hEngineerigDataObject,
    FILE *psFile
        );

/* Object Private Prototypes */
static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromDecoder(
    DECODER_OBJECT hDecoder,
    ENGINEERING_DATA_OBJECT_STRUCT **ppsObj
        );

  /***************/
 /** VARIABLES **/
/***************/

static const ENGINEERING_DATA_OBJECT_STRUCT gsObjectDefaults =
{
    DETAILED_SIGNAL_QUALITY_INVALID_OBJECT,
    DETAILED_OVERLAY_SIGNAL_QUALITY_INVALID_OBJECT,
    LINK_STATUS_INFORMATION_INVALID_OBJECT,
    //audio decoder bitrate initialized to zero
    0,
     // Engineering Data Update Control Structure
    {
        // Object update masks
        SMS_OBJECT_EVENT_NONE,
        SMS_OBJECT_EVENT_NONE,
        SMS_OBJECT_EVENT_NONE,
        SMS_OBJECT_EVENT_NONE,

        // Object update callback list
        OSAL_INVALID_OBJECT_HDL,
        OSAL_INVALID_LINKED_LIST_ENTRY,

        // Object being updated
        NULL,

        // In-active callbacks
        FALSE
    }
};


// Global (re-usable) instance of an interface for this object
const ENGINEERING_DATA_OBJECT_INTERFACE_STRUCT ENGINEERING_DATA =
{
    /* Object Members */
    /*.tEventMask = */tEventMask,
    /*.hSignalQualityDetailed = */hSignalQualityDetailed,
    /*.hOverlaySignalQualityDetailed = */hOverlaySignalQualityDetailed,
    /*.eAudioDecoderBitrate = */eAudioDecoderBitrate,
    /*.hLinkStatusInformation = */hLinkStatusInformation,
    /*.n32FPrintf =*/n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _ENGINEERING_DATA_OBJ_H_
