/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DSRL_TARGET_OBJ_H_
#define _DSRL_TARGET_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define DSRL_TARGET_PREFIX "DT"


  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct DSRL_TARGET_object_struct
{
    DSRL_TARGET_TYPE_ENUM eType;

} DSRL_TARGET_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static DSRL_TARGET_TYPE_ENUM eType (
    DSRL_TARGET_OBJECT hTarget
        );

static LOCATION_OBJECT hLocation (
    DSRL_TARGET_OBJECT hTarget
        );

static STOCK_SYMBOL_OBJECT hStockSymbol (
    DSRL_TARGET_OBJECT hTarget
        );

/* Object Private Prototypes */

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const DSRL_TARGET_OBJECT_INTERFACE_STRUCT DSRL_TARGET =
{
    /*.eType = */eType,
    /*.hLocation = */hLocation,
    /*.hStockSymbol = */hStockSymbol
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _DSRL_TARGET_OBJ_H_
