/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DISTANCE_OBJ_H_
#define _DISTANCE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define DISTANCE_OBJECT_NAME "DISTANCE"

#define DEFAULT_DISTANCE_TYPE (DISTANCE_UNIT_TYPE_MILES)

// The fractional bits to define a distance.
#define DISTANCE_FRACTIONAL_BITS (16)

// Earth radius, in miles and kilomieters, converted to a fixed point number
// Theses values found at http://en.wikipedia.org/wiki/Earth%27s_radius
#define FIXED_EARTH_RADIUS_MILES (3959 <<  DISTANCE_FRACTIONAL_BITS)
#define FIXED_EARTH_RADIUS_KM (6371 <<  DISTANCE_FRACTIONAL_BITS)

// Conversion factors for converting between unit types
#define MILES_TO_KILOMETERS ((N32)(1.609344f * (1 << DISTANCE_FRACTIONAL_BITS)))
#define KILOMETERS_TO_MILES ((N32)(0.621371192f * (1 << DISTANCE_FRACTIONAL_BITS)))


  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct distance_object_struct
{
    // The value this distance represents
    OSAL_FIXED_OBJECT_DATA atValueData[OSAL_FIXED_OBJECT_SIZE];
    OSAL_FIXED_OBJECT hValue;

    // The type of units this distance is
    DISTANCE_UNIT_TYPE_ENUM eUnits;

    // protected instance variable
    BOOLEAN bIsVector;
    OSAL_FIXED_OBJECT_DATA atConvertedValue[OSAL_FIXED_OBJECT_SIZE];
    OSAL_FIXED_OBJECT hConvertedValue;

} DISTANCE_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static DISTANCE_OBJECT hCreate (
    N32 n32Value,
    DISTANCE_UNIT_TYPE_ENUM eUnits
        );

static DISTANCE_OBJECT hDuplicate (
    DISTANCE_OBJECT hDistance
        );

static OSAL_FIXED_OBJECT hValue (
    DISTANCE_OBJECT hDistance,
    DISTANCE_UNIT_TYPE_ENUM eUnits
        );

static N16 n16Compare (
    DISTANCE_OBJECT hDistance1,
    DISTANCE_OBJECT hDistance2
        );

static N32 n32FWrite (
    DISTANCE_OBJECT hDistance,
    FILE *psFile
        );

static DISTANCE_OBJECT hFRead (
    FILE *psFile
        );

static N32 n32FPrintf (
    DISTANCE_OBJECT hDistance,
    FILE *psFile
        );

static void vDestroy (
    DISTANCE_OBJECT hDistance
        );

/* Object Private Prototypes */
static BOOLEAN bConvertUnits (
    DISTANCE_OBJECT_STRUCT *psObj,
    DISTANCE_UNIT_TYPE_ENUM eUnitsToConvertTo,
    OSAL_FIXED_OBJECT hResult
        );

static BOOLEAN bMultiplyByEarthsRadius(
    OSAL_FIXED_OBJECT hDistanceVector,
    DISTANCE_UNIT_TYPE_ENUM eUnits,
    OSAL_FIXED_OBJECT hResult
        );

static const char *pacUnitsText(
    DISTANCE_UNIT_TYPE_ENUM eUnits
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const DISTANCE_OBJECT_INTERFACE_STRUCT DISTANCE =
{
    /*.hCreate = */hCreate,
    /*.hDuplicate = */hDuplicate,
    /*.hValue = */hValue,
    /*.n16Compare = */n16Compare,
    /*.n32FWrite = */n32FWrite,
    /*.hFRead = */hFRead,
    /*.n32FPrintf = */n32FPrintf,
    /*.vDestroy = */vDestroy
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _DISTANCE_OBJ_H_
