/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DEVICE_OBJ_H_
#define _DEVICE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "srm_obj.h"
#include "sms_update.h"
#include "dataservice_mgr_obj.h"
#include "dataservice_base.h"
#include "distance_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define DEVICE_OBJECT_NAME "DEVICE"

  /**************/
 /** TYPEDEFS **/
/**************/

// Registration description for either manager or callback
typedef struct device_registration_struct
{
    DEVICE_UPDATE_CALLBACK vCallback;

    // Registration argument
    void *pvRegistrationArg;

    // Callback argument
    void *pvCallbackArg;

    // Interested distance
    DISTANCE_OBJECT hDistance;

    // Last notified location
    LOCATION_OBJECT hLastNotifiedLocation;

    // Notification list entry
    OSAL_LINKED_LIST_ENTRY hEntry;

} DEVICE_REGISTRATION_STRUCT;

// Registration entry printout interator struct
typedef struct device_reg_print_iterator_struct
{
    // File pointer to write to
    FILE *psFile;
    // Pointer to global bytes counter
    N32 *pn32BytesWritten;
    // Entries counter
    UN8 un8Counter;

} DEVICE_REG_PRINT_ITERATOR_STRUCT;

// Device Location object structure
typedef struct device_object_struct
{
    // List of registered managers which contains DATAMGR_DESC_STRUCT
    // instances
    OSAL_OBJECT_HDL hRegistrationList;

    // Current location
    LOCATION_OBJECT hCurrentLocation;

    // Flag indicates knowledge of position
    BOOLEAN bPositionAvailable;

} DEVICE_OBJECT_STRUCT;

// Structure used to aid in notification iterator
typedef struct device_position_notify_struct
{
    DEVICE_EVENT_MASK tEventMask;
    LOCATION_OBJECT hLocation;

} DEVICE_POSITION_NOTIFY_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static BOOLEAN bSetPosition (
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

static BOOLEAN bGetPosition (
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

static DEVICE_REGISTRATION_OBJECT hRegisterForUpdates (
    DISTANCE_OBJECT hDistance,
    void *pvRegistrationArgument,
    DEVICE_UPDATE_CALLBACK vCallback,
    void *pvCallbackArg
        );

static void vUnregisterForUpdates (
    DEVICE_REGISTRATION_OBJECT hRegistration
        );

static void *pvRegistrationArgument (
    DEVICE_REGISTRATION_OBJECT hRegistration
        );

static BOOLEAN bReplaceRegistrationArgument (
    DEVICE_REGISTRATION_OBJECT hRegistration,
    BOOLEAN bNotify,
    void *pvRegistrationArg
        );

/* Object Private Prototypes */
static DEVICE_OBJECT_STRUCT *psGetDevFromDSM ( void );

static DEVICE_REGISTRATION_OBJECT hRegisterLocal (
    DEVICE_OBJECT_STRUCT *psObj,
    DISTANCE_OBJECT hDistance,
    void *pvRegistrationArgument,
    DEVICE_UPDATE_CALLBACK vCallback,
    void *pvCallbackArg
        );

static DEVICE_REGISTRATION_STRUCT *psCreateReg(
    DEVICE_OBJECT_STRUCT *psObj,
    DISTANCE_OBJECT hDistance,
    void *pvRegistrationArg,
    DEVICE_UPDATE_CALLBACK vCallback,
    void *pvCallbackArg
        );

static BOOLEAN bAddRegistrationToList(
    DEVICE_OBJECT_STRUCT *psObj,
    DEVICE_REGISTRATION_STRUCT *psReg
        );

static void vDestroyReg (
    DEVICE_REGISTRATION_STRUCT *psReg
        );

static BOOLEAN bNotifyByLocation (
    DEVICE_REGISTRATION_STRUCT *psReg,
    DEVICE_POSITION_NOTIFY_STRUCT *psNotify
        );

static BOOLEAN bPrintRegEntry(
    DEVICE_REGISTRATION_STRUCT *psReg,
    DEVICE_REG_PRINT_ITERATOR_STRUCT *psIterator
        );

static BOOLEAN bUpdateLocation(
    LOCATION_OBJECT *phLocation,
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon
        );

static BOOLEAN bUpdateFixed(
    OSAL_FIXED_OBJECT hFrom,
    OSAL_FIXED_OBJECT hTo
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const DEVICE_OBJECT_INTERFACE_STRUCT DEVICE = {
    /*.bSetPosition = */ bSetPosition,
    /*.bGetPosition = */ bGetPosition,
    /*.hRegisterForUpdates =*/ hRegisterForUpdates,
    /*.vUnregisterForUpdates = */ vUnregisterForUpdates,
    /*.pvRegistrationArgument = */pvRegistrationArgument,
    /*.bReplaceRegistrationArgument = */bReplaceRegistrationArgument
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/
#endif  // _DEVICE_OBJ_H_
