/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DETAILED_SIGNAL_QUALITY_OBJ_H_
#define _DETAILED_SIGNAL_QUALITY_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "string_obj.h"
#include "engineering_data_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define DETAILED_SIGNAL_QUALITY_OBJECT_NAME "DETAILED_SIGNAL_QUALITY_OBJECT"

#define PERCENT_SIZE 5
#define CN_SIZE 6
#define CARRIER_FREQ_OFFSET_SIZE 7
#define RSSI_SIZE 5
#define BYTEFIELD_SIZE 4
#define INVALID_3 "xxx"
#define INVALID_4 "xxxx"
#define INVALID_5 "xxxxx"
#define MAX_STRING_SIZE 7
#define NO_ACTIVE_PIPE 9999
#define NO_ACTIVE_PIPE_STR " 999"
#define MAX_RSSI_DISPLAY 0
#define MIN_RSSI_DISPLAY -128
#define MAX_OFFSET_DISPLAY 999
#define MIN_OFFSET_DISPLAY -999
#define MAX_OFFSET_STRING "99999"
#define MIN_OFFSET_STRING "-99999"
#define DECIMAL_BASE 10
#define MAX_PERCENT 100

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */
typedef struct detailed_signal_quality_object_struct
{
    STRING_OBJECT hSigStrength;
    STRING_OBJECT hTunerStatus;
    STRING_OBJECT hENSALockStatus;
    STRING_OBJECT hENSBLockStatus;
    STRING_OBJECT hBERS1;
    STRING_OBJECT hBERS2;
    STRING_OBJECT hBERT;
    STRING_OBJECT hCNS1A;
    STRING_OBJECT hCNS1B;
    STRING_OBJECT hCNS2A;
    STRING_OBJECT hCNS2B;
    STRING_OBJECT hRSErrsWord;
    STRING_OBJECT hRSErrsSatSymb;
    STRING_OBJECT hRSErrsTerrSymb;
    STRING_OBJECT hTunerCarrierFreqOffset;
    STRING_OBJECT hRSSI;
    BOOLEAN bFirstUpdateReceived;
    DETAILED_SIGNAL_QUALITY_STRUCT sCurrentSignalQuality;

} DETAILED_SIGNAL_QUALITY_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static STRING_OBJECT hSigStrength (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hTunerStatus (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hENSALockStatus (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hENSBLockStatus (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hBERS1 (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hBERS2 (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hBERT (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hCNS1A (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hCNS1B (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hCNS2A (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hCNS2B (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hRSErrsWord (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hRSErrsSatSymb (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hRSErrsTerrSymb (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hTunerCarrierFreqOffset (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static STRING_OBJECT hRSSI (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality
        );

static N32 n32FPrintf (
    DETAILED_SIGNAL_QUALITY_OBJECT hDetSigQuality,
    FILE *psFile
        );

/* Object Private Prototypes */
static void vPercentStringModify(
    STRING_OBJECT hStrTargetObj,
    UN16 un16PercentValue
        );

static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromDecoder(
    DECODER_OBJECT hDecoder,
    DETAILED_SIGNAL_QUALITY_OBJECT_STRUCT **ppsObj
        );

static void vReleaseStrings(
    DETAILED_SIGNAL_QUALITY_OBJECT hDetailedSignalQuality
        );

  /***************/
 /** VARIABLES **/
/***************/

static const DETAILED_SIGNAL_QUALITY_OBJECT_STRUCT gsObjectDefaults =
{
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    FALSE,
    //Initialize the numeric data to zero.
    {
        DETAILED_SIGNAL_QUALITY_NONE,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0
    }

};


// Global (re-usable) instance of an interface for this object
const DETAILED_SIGNAL_QUALITY_OBJECT_INTERFACE_STRUCT DETAILED_SIGNAL_QUALITY =
{
    /* Object Members */
    /*.hSigStrength = */hSigStrength,
    /*.hTunerStatus = */hTunerStatus,
    /*.hENSALockStatus = */hENSALockStatus,
    /*.hENSBLockStatus = */hENSBLockStatus,
    /*.hBERS1 = */hBERS1,
    /*.hBERS2 = */hBERS2,
    /*.hBERT = */hBERT,
    /*.hCNS1A =*/hCNS1A,
    /*.hCNS1B =*/hCNS1B,
    /*.hCNS2A =*/hCNS2A,
    /*.hCNS2B =*/hCNS2B,
    /*.hRSErrsWord =*/hRSErrsWord,
    /*.hRSErrsSatSymb =*/hRSErrsSatSymb,
    /*.hRSErrsTerrSymb =*/hRSErrsTerrSymb,
    /*.hTunerCarrierFreqOffset =*/hTunerCarrierFreqOffset,
    /*.hRSSI =*/hRSSI,
    /*.n32FPrintf =*/n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _DETAILED_SIGNAL_QUALITY_OBJ_H_
