/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _DETAILED_OVERLAY_SIGNAL_QUALITY_OBJ_H_
#define _DETAILED_OVERLAY_SIGNAL_QUALITY_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "string_obj.h"
#include "radio.h"
#include "detailed_overlay_signal_quality_obj.h"
#include "engineering_data_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_NAME \
                    "DETAILED_OVERLAY_SIGNAL_QUALITY"

#define PERCENT_SIZE 5
#define BYTEFIELD_SIZE 4
#define MAX_STRING_SIZE 5
#define INVALID_3 "xxx"
#define INVALID_4 "xxxx"
#define NO_ACTIVE_PIPE 9999
#define NO_ACTIVE_PIPE_STR "--- "
#define DECIMAL_BASE 10
#define MAX_PERCENT 100

  /**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */

typedef struct detailed_overlay_signal_quality_object_struct
{
    STRING_OBJECT hReceiverState;
    STRING_OBJECT hOBERS1A;
    STRING_OBJECT hOBERS1B;
    STRING_OBJECT hOBERS2A;
    STRING_OBJECT hOBERS2B;
    STRING_OBJECT hOBERTerrA;
    STRING_OBJECT hOBERTerrB;
    STRING_OBJECT hOBERTurboWordErrRate0A;
    STRING_OBJECT hOBERTurboWordErrRate1A;
    STRING_OBJECT hOBERTurboWordErrRate2A;
    STRING_OBJECT hOBERTurboWordErrRate0B;
    STRING_OBJECT hOBERTurboWordErrRate1B;
    STRING_OBJECT hOBERTurboWordErrRate2B;
    BOOLEAN bFirstUpdateReceived;
    DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT sCurrentOverlaySignalQuality;

} DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hReceiverState (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERS1A (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERS1B (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERS2A (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERS2B (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTerrA (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTerrB (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTurboWordErrRate0A (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTurboWordErrRate1A (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTurboWordErrRate2A (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTurboWordErrRate0B (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTurboWordErrRate1B (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static STRING_OBJECT hOBERTurboWordErrRate2B (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality
        );

static N32 n32FPrintf (
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetOverlaySigQuality,
    FILE *psFile
        );

/* Private Function Prototypes */
static SMSAPI_RETURN_CODE_ENUM eAccessObjectFromDecoder(
    DECODER_OBJECT hDecoder,
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT **ppsObj
        );

static void vPercentStringModify(
    STRING_OBJECT hStrTargetObj,
    UN16 un16PercentValue
        );

static void vReleaseStrings(
    DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT hDetailedOverlaySignalQuality
        );

  /***************/
 /** VARIABLES **/
/***************/

static const DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_STRUCT gsObjectDefaults =
{
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    STRING_INVALID_OBJECT,
    FALSE,
    //detailed_overlay_signal_quality_struct
    {
        //Initialize all numeric values to zero
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0
    }

};


// Global (re-usable) instance of an interface for this object
const DETAILED_OVERLAY_SIGNAL_QUALITY_OBJECT_INTERFACE_STRUCT
            DETAILED_OVERLAY_SIGNAL_QUALITY =
{
    /* Object Members */
    /*.hReceiverState = */hReceiverState,
    /*.hOBERS1A = */hOBERS1A,
    /*.hOBERS1B = */hOBERS1B,
    /*.hOBERS2A = */hOBERS2A,
    /*.hOBERS2B = */hOBERS2B,
    /*.hOBERTerrA = */hOBERTerrA,
    /*.hOBERTerrB = */hOBERTerrB,
    /*.hOBERTurboWordErrRate0A =*/hOBERTurboWordErrRate0A,
    /*.hOBERTurboWordErrRate0B =*/hOBERTurboWordErrRate1A,
    /*.hOBERTurboWordErrRate0A =*/hOBERTurboWordErrRate2A,
    /*.hOBERTurboWordErrRate0B =*/hOBERTurboWordErrRate0B,
    /*.hOBERTurboWordErrRate0A =*/hOBERTurboWordErrRate1B,
    /*.hOBERTurboWordErrRate0B =*/hOBERTurboWordErrRate2B,
    /*.n32FPrintf =*/n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  //_DETAILED_OVERLAY_SIGNAL_QUALITY_OBJ_H_
