/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _CID_INTEGER_H_
#define _CID_INTEGER_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "cid_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"



  /************/
 /** MACROS **/
/************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef UN32 CID_INTEGER_VALUE_TYPE;

typedef struct cid_integer_struct
{
    CID_INTEGER_VALUE_TYPE tValue;
    BOOLEAN bConstant;
} CID_INTEGER_STRUCT;

typedef struct cid_integer_object * CID_INTEGER_OBJECT;
#define CID_INTEGER_INVALID_OBJECT (CID_INTEGER_OBJECT)NULL

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

  /***************/
 /** VARIABLES **/
/***************/

// Global structure defining the CID integer Object Data Interface
const CID_TYPE_OBJ_DATA_INTERFACE_STRUCT GsCidIntegerIntf =
{
    // Object Data Minimum size
    /*.tMinSize = */MAX_INTEGER_AS_CHARS,

    // Object Data Create/Destroy Methods
    /*.pvCreate = */CIDINT_pvCreate,
    /*.vDestroy = */CIDINT_vDestroy,

    // Object Data Manipulation Methods
    /*.pvDuplicate = */CIDINT_pvDuplicate,
    /*.bModify = */CIDINT_bModify,
    /*.bCopy = */CIDINT_bCopy,
    /*.tSize = */CIDINT_tSize,
    /*.n16Compare = */CIDINT_n16Compare,

    // Object Data I/O Methods
    /*.n32FWrite = */CIDINT_n32FWrite,
    /*.n32FWriteToMemory = */CIDINT_n32FWriteToMemory,
    /*.pvRead = */CIDINT_pvRead,
    /*.bReadFromMemory = */CIDINT_bReadFromMemory,
    /*.n32FPrintf = */CIDINT_n32FPrintf,
    /*.n32GetValue = */CIDINT_n32GetValue
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _CID_INTEGER_H_
