/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _BROWSE_OBJ_H_
#define _BROWSE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define BROWSE_OBJECT_NAME "Browse"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct browse_object_struct
{
    // Object which created this browse object
    SMS_OBJECT hOwner;

    // Decoder upon which we operate
    DECODER_OBJECT hDecoder;

    // Channel Cache from DECODER
    CCACHE_OBJECT hCCache;

    // Our current browse type
    BROWSE_TYPE_ENUM eBrowseType;

    // The current reference channel id
    CHANNEL_ID tReferenceChannelId;

    // The current reference category id
    CATEGORY_ID tReferenceCategoryId;

    // The offset at which the channel resides
    // within the current category.
    N16 n16ChannelCategoryOffset;

    // Browse comparators and arguments
    BROWSE_CHANNEL_COMPARE_HANDLER bBrowseChannelCompareHandler;
    BROWSE_CATEGORY_COMPARE_HANDLER bBrowseCategoryCompareHandler;
    void *pvBrowseChannelCompareArg;
    void *pvBrowseCategoryCompareArg;

} BROWSE_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */

static BOOLEAN bBrowseChannels (
    const BROWSE_OBJECT_STRUCT *psObj,
    SMSAPI_DIRECTION_ENUM eDirection,
    CHANNEL_ID *ptChannelId,
    N16 *pn16ChannelOffset,
    CATEGORY_ID *ptCategoryId
        );

static BOOLEAN bBrowseChannelsByCategory (
    const BROWSE_OBJECT_STRUCT *psObj,
    SMSAPI_DIRECTION_ENUM eDirection,
    CHANNEL_ID *ptChannelId,
    N16 *pn16ChannelOffset,
    CATEGORY_ID *ptCategoryId
        );

static BOOLEAN bBrowseAllChannels (
    const BROWSE_OBJECT_STRUCT *psObj,
    SMSAPI_DIRECTION_ENUM eDirection,
    CHANNEL_ID *ptChannelId,
    N16 *pn16ChannelOffset,
    CATEGORY_ID *ptCategoryId
        );

static BOOLEAN bBrowseCategories (
    const BROWSE_OBJECT_STRUCT *psObj,
    SMSAPI_DIRECTION_ENUM eDirection,
    CHANNEL_ID *ptChannelId,
    N16 *pn16ChannelOffset,
    CATEGORY_ID *ptCategoryId,
    BOOLEAN bBrowsingChanlist
        );

static BOOLEAN bNavigateToRequestedOffset (
    const BROWSE_OBJECT_STRUCT *psObj,
    N16 n16RequestedOffset,
    CHANNEL_ID *ptChannelId,
    N16 *pn16ChannelOffset,
    CATEGORY_ID *ptCategoryId,
    BOOLEAN bBrowsingChanlist
        );

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _BROWSE_OBJ_H_
