/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _BAUDOT_CODES_H_
#define _BAUDOT_CODES_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "baudot.h"

  /***************/
 /** CONSTANTS **/
/***************/

#define NUM_BAUDOT_ENTRIES \
    (sizeof(gasChars) / sizeof(BAUDOT_ENTRY_STRUCT))

  /**************/
 /** TYPEDEFS **/
/**************/

typedef enum baudot_command_enum
{
    BAUDOT_COMMAND_END = 0,
    BAUDOT_COMMAND_LF,
    BAUDOT_COMMAND_FL,
    BAUDOT_COMMAND_CAPS,
    BAUDOT_COMMAND_RETURN,
    BAUDOT_COMMAND_ESC,
    BAUDOT_COMMAND_NONE

} BAUDOT_COMMAND_ENUM;

typedef struct baudot_entry_struct
{
    const BAUDOT_CHAR tUppercaseLetter;
    const BAUDOT_CHAR tLowercaseLetter;
    const BAUDOT_CHAR tFigure;
    const BAUDOT_CHAR tEscapedUppercase;
    const BAUDOT_CHAR tEscapedLowercase;
    const BAUDOT_CHAR tEscapedFigure;

} BAUDOT_ENTRY_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/
static const BAUDOT_ENTRY_STRUCT gasChars[] =
{
    {   // Entry 0
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_END,
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_END,
        /*.tFigure           = */(const BAUDOT_CHAR)BAUDOT_COMMAND_END,
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC0,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE0,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x22
    },

    {   // Entry 1
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'E',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'e',
        /*.tFigure           = */(const BAUDOT_CHAR)'3',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC1,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE1,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x3B
    },

    {   // Entry 2
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_CAPS,
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_CAPS,
        /*.tFigure           = */(const BAUDOT_CHAR)'+',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC2,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE2,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x3C
    },

    {   // Entry 3
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'A',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'a',
        /*.tFigure           = */(const BAUDOT_CHAR)'-',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC3,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE3,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x3D
    },

    {   // Entry 4
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)' ',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)' ',
        /*.tFigure           = */(const BAUDOT_CHAR)' ',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC4,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE4,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x3E
    },

    {   // Entry 5
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'S',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'s',
        /*.tFigure           = */(const BAUDOT_CHAR)'\'',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC5,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE5,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x5B
    },

    {   // Entry 6
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'I',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'i',
        /*.tFigure           = */(const BAUDOT_CHAR)'8',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC6,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE6,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x5C
    },

    {   // Entry 7
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'U',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'u',
        /*.tFigure           = */(const BAUDOT_CHAR)'7',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC7,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE7,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x5D
    },

    {   // Entry 8
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_RETURN,
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_RETURN,
        /*.tFigure           = */(const BAUDOT_CHAR)BAUDOT_COMMAND_RETURN,
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC8,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE8,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x5E
    },

    {   // Entry 9
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'D',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'d',
        /*.tFigure           = */(const BAUDOT_CHAR)'$',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xC9,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xE9,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x5F
    },

    {   // Entry 10
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'R',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'r',
        /*.tFigure           = */(const BAUDOT_CHAR)'4',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xCA,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xEA,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x60
    },

    {   // Entry 11
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'J',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'j',
        /*.tFigure           = */(const BAUDOT_CHAR)'*',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xCB,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xEB,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x7B
    },

    {   // Entry 12
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'N',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'n',
        /*.tFigure           = */(const BAUDOT_CHAR)',',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xCC,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xEC,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x7C
    },

    {   // Entry 13
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'F',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'f',
        /*.tFigure           = */(const BAUDOT_CHAR)'!',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xCD,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xED,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x7D
    },

    {   // Entry 14
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'C',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'c',
        /*.tFigure           = */(const BAUDOT_CHAR)':',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xCE,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xEE,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0x7E
    },

    {   // Entry 15
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'K',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'k',
        /*.tFigure           = */(const BAUDOT_CHAR)'(',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xCF,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xEF,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0xAB
    },

    {   // Entry 16
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'T',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'t',
        /*.tFigure           = */(const BAUDOT_CHAR)'5',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0x8C,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0x9C,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0xBB
    },

    {   // Entry 17
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'Z',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'z',
        /*.tFigure           = */(const BAUDOT_CHAR)'%',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD1,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF1,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)0xA2
    },

    {   // Entry 18
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'L',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'l',
        /*.tFigure           = */(const BAUDOT_CHAR)')',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD2,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF2,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 19
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'W',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'w',
        /*.tFigure           = */(const BAUDOT_CHAR)'2',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD3,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF3,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 20
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'H',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'h',
        /*.tFigure           = */(const BAUDOT_CHAR)'#',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD4,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF4,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 21
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'Y',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'y',
        /*.tFigure           = */(const BAUDOT_CHAR)'6',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD5,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF5,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 22
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'P',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'p',
        /*.tFigure           = */(const BAUDOT_CHAR)'0',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD6,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF6,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 23
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'Q',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'q',
        /*.tFigure           = */(const BAUDOT_CHAR)'1',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xA1,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xBF,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 24
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'O',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'o',
        /*.tFigure           = */(const BAUDOT_CHAR)'9',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD8,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF8,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 25
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'B',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'b',
        /*.tFigure           = */(const BAUDOT_CHAR)'?',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xD9,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xF9,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 26
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'G',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'g',
        /*.tFigure           = */(const BAUDOT_CHAR)'&',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xDA,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xFA,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 27
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_ESC,
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_ESC,
        /*.tFigure           = */(const BAUDOT_CHAR)BAUDOT_COMMAND_ESC,
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xDB,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xFB,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 28
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'M',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'m',
        /*.tFigure           = */(const BAUDOT_CHAR)'.',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xDC,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xFC,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 29
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'X',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'x',
        /*.tFigure           = */(const BAUDOT_CHAR)'/',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xDD,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xFD,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 30
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)'V',
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)'v',
        /*.tFigure           = */(const BAUDOT_CHAR)'@',
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xA9,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xAE,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    },

    {   // Entry 31
        /*.tUppercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_LF,
        /*.tLowercaseLetter  = */(const BAUDOT_CHAR)BAUDOT_COMMAND_LF,
        /*.tFigure           = */(const BAUDOT_CHAR)BAUDOT_COMMAND_FL,
        /*.tEscapedUppercase = */(const BAUDOT_CHAR)0xDF,
        /*.tEscapedLowercase = */(const BAUDOT_CHAR)0xFF,
        /*.tEscapedFigure    = */(const BAUDOT_CHAR)BAUDOT_COMMAND_NONE
    }
};

#endif /* _BAUDOT_CODES_H_ */
