/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AT_SEEK_CONTENT_H
#define _AT_SEEK_CONTENT_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "seek_content.h"
#include "at_seek_content.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define AT_SEEK_CONTENT_OBJECT_NAME "AT_SEEK_CONTENT"


  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hRegisteredArtistText (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static STRING_OBJECT hRegisteredTitleText (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static AT_SEEK_ENUM eType (
    SEEK_CONTENT_OBJECT hSeekContent
        );

static BOOLEAN bConvertible (
    SEEK_CONTENT_OBJECT hSeekContent,
    AT_SEEK_ENUM eConvertToType
        );

static SMSAPI_RETURN_CODE_ENUM eConvert (
    SEEK_CONTENT_OBJECT hSeekContent,
    AT_SEEK_ENUM eConvertToType
        );

/* Object Private Prototypes */

static N32 n32FPrintf (
    void *pvServiceSpecific,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

static void vUnInit(
    void *pvServiceSpecific
        );

static CID_OBJECT hCIDForConversion(
    SEEK_CONTENT_OBJECT hSeekContent,
    AT_SEEK_ENUM eConvertToType
        );

static BOOLEAN bSearchForCurrentAfterEnable (
    void *pvServiceSpecific
        );

  /***************/
 /** VARIABLES **/
/***************/

// service specific content interface for the A/T Seek Service
const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsATSeekContent =
{
    /*.vUnInit = */vUnInit,
    /*.n32FPrintf = */n32FPrintf,
    /*.bSearchForCurrentAfterEnable = */bSearchForCurrentAfterEnable
};

// Global instance of an interface for this object
const AT_SEEK_CONTENT_INTERFACE_STRUCT AT_SEEK_CONTENT =
{
    /*.hRegisteredArtistText = */hRegisteredArtistText,
    /*.hRegisteredTitleText = */hRegisteredTitleText,
    /*.eType = */eType,
    /*.bConvertible = */bConvertible,
    /*.eConvert = */eConvert
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _AT_SEEK_CONTENT_H
