/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AT_SEEK_H
#define _AT_SEEK_H

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

#include "tag_obj.h"
#include "seek.h"
#include "seek_content.h"
#include "at_seek.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AT_SEEK_OBJECT_NAME "AT_SEEK"

#define AT_SEEK_CAL_AUTO_ADD_OPTIONS \
         ( CAL_AUTO_ADD_OPTION_IF_TUNED  | \
           CAL_AUTO_ADD_OPTION_IF_NOT_TUNED  | \
           CAL_AUTO_ADD_OPTION_UNIQUE | \
           CAL_AUTO_ADD_OPTION_BOTTOM  )

#define AT_SEEK_TYPE                   "Type"
#define AT_SEEK_ENABLED                "Enabled"
#define AT_SEEK_ARTIST_CID             "ArtistCID"
#define AT_SEEK_TITLE_CID              "TitleCID"
#define AT_SEEK_TITLE_TEXT             "TitleText"
#define AT_SEEK_ARTIST_TEXT            "ArtistText"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct registered_content_tag_iterator_struct
{
    SEEK_SERVICE_OBJECT_STRUCT *psObj;
} REGISTERED_CONTENT_TAG_ITERATOR_STRUCT;

typedef struct at_seek_iterator_struct
{
    BOOLEAN bMatch;
    CID_OBJECT hId;
} AT_SEEK_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

static SMSAPI_RETURN_CODE_ENUM eAvailableToRegister (
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    SEEK_AVAILABILTY_ENUM *peTitleAvailablility,
    SEEK_AVAILABILTY_ENUM *peArtistAvailablility
        );

static SMSAPI_RETURN_CODE_ENUM eRegister (
    DECODER_OBJECT hDecoder,
    AT_SEEK_ENUM eType,
    CHANNEL_ID tChannelId,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

/* Object Private Prototypes */

static BOOLEAN bSeekAlertAllowed(
    SEEK_SERVICE_OBJECT hSeek,
    CAL_CONTENT_OBJECT hContent,
    CHANNEL_OBJECT hChannel
        );

static CD_OBJECT hGetCDOAndCids(
    DECODER_OBJECT hDecoder,
    CHANNEL_ID tChannelId,
    CID_OBJECT *phArtistCID,
    CID_OBJECT *phTitleCID
        );

static BOOLEAN bRetrieveCidsForSeeks(
    CD_OBJECT hCDO,
    CID_OBJECT *phArtistCID,
    CID_OBJECT *phTitleCID
        );

static BOOLEAN bHandleSeekAlert(
    SEEK_SERVICE_OBJECT hSeek,
    CAL_ALERT_OBJECT hAlert
        );

static BOOLEAN bInit(
    SEEK_SERVICE_OBJECT hSeek
        );

static BOOLEAN bAddToConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psItem,
    STRING_OBJECT hArtistTextString,
    STRING_OBJECT hTitleTextString
        );

static SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psRegisterContent(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    CID_OBJECT hArtistCID,
    CID_OBJECT hTitleCID,
    AT_SEEK_ENUM eType,
    CID_OBJECT hCID,
    STRING_OBJECT hArtistTextString,
    STRING_OBJECT hTitleTextString,
    BOOLEAN bEnabled,
    SEEK_CONTENT_OBJECT *phSeekContent
        );

static BOOLEAN bRegisterContentFromConfigFile(
    SEEK_SERVICE_OBJECT_STRUCT *psObj
        );

static BOOLEAN bRegisteredContentTagIterator(
    TAG_OBJECT hTag,
    void *pvArg
        );

static SMSAPI_RETURN_CODE_ENUM eGetEnabledFromTag(
    SEEK_SERVICE_OBJECT_STRUCT *psObj,
    TAG_OBJECT hTag,
    BOOLEAN *pbEnabled
        );

static AT_SEEK_ENUM eGetATSeekTypeFromTags(
    TAG_OBJECT hTag
        );

static SMSAPI_RETURN_CODE_ENUM eGetCidsFromTags(
    TAG_OBJECT hTag,
    AT_SEEK_ENUM eType,
    CID_OBJECT *phCID,
    CID_OBJECT *phArtistCID,
    CID_OBJECT *phTitleCID
        );

static SMSAPI_RETURN_CODE_ENUM eGetArtistTitleTextFromTags(
    TAG_OBJECT hTag,
    STRING_OBJECT *phArtistText,
    STRING_OBJECT *phTitleText
        );

static SMSAPI_RETURN_CODE_ENUM eWriteTypeToTag(
    TAG_OBJECT hParentTag,
    AT_SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psATSpecificInfo
        );

static SMSAPI_RETURN_CODE_ENUM eWriteCIDsToTag(
    TAG_OBJECT hParentTag,
    AT_SEEK_CONTENT_REGISTERED_ITEM_STRUCT *psATSpecificInfo
        );

static SMSAPI_RETURN_CODE_ENUM eWriteTextToTag(
    TAG_OBJECT hParentTag,
    const char *pacTagName,
    STRING_OBJECT hText
        );

static SMSAPI_RETURN_CODE_ENUM eAddToConfigFile (
    TAG_OBJECT hParentTag,
    void *pvItem,
    STRING_OBJECT hArtistTextString,
    STRING_OBJECT hTitleTextString
        );

static BOOLEAN bATSeekContentIterator(
    DECODER_OBJECT hDecoder,
    SEEK_SERVICE_ENUM eService,
    SEEK_CONTENT_OBJECT hContent,
    void *pvSeekContentIteratorArg
        );

  /***************/
 /** VARIABLES **/
/***************/
// service specific interface for the A/T Seek Service
static const SEEK_SERVICE_SPECIFIC_INTERFACE_STRUCT gsATSeekInterface =
{
    /*.bInit = */bInit,
    /*.vUnInit = */NULL,
    /*.n32FPrintf = */NULL,
    /*.bHandleSeekAlert = */bHandleSeekAlert
};

// the artist/title content interface struct which gets placed into the
// artist/title seek service info struct
extern const SEEK_CONTENT_OBJ_INTERFACE_STRUCT GsATSeekContent;

// service specific info struct for the A/T Seek Service
const SEEK_SERVICE_SPECIFIC_INFO_STRUCT GsATSeek =
{
    /*.eService = */SEEK_SERVICE_ARTIST_TITLE,
    /*.psInterface = */&gsATSeekInterface,
    /*.psContentInterface = */&GsATSeekContent
};

// Global instance of an interface for this object
const AT_SEEK_INTERFACE_STRUCT AT_SEEK =
{
    /*.eAvailableToRegister = */eAvailableToRegister,
    /*.eRegister = */eRegister
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _AT_SEEK_H
