/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _ALERTC_EVENT_OBJ_H_
#define _ALERTC_EVENT_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define ALERTC_EVENT_OBJECT_NAME "ALERTC_EVENT"

/**************/
 /** TYPEDEFS **/
/**************/

/* Private object elements */
typedef struct alertc_event_object_struct
{
    TRAFFIC_EVENT_CODE tCode;
    ALERTC_EVENT_TYPE_ENUM eType;
    TRAFFIC_MSG_CLASS_ENUM eClass;
    ALERTC_QUANTIFIER_TYPE_ENUM eQuantType;
    STRING_OBJECT hText;
    STRING_OBJECT hTextMod;

} ALERTC_EVENT_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* object private prototypes */


  /***************/
 /** VARIABLES **/
/***************/


  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _ALERTC_EVENT_OBJ_H_
