/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_WIND_RADII_AREA_OBJ_H_
#define _AGW_WIND_RADII_AREA_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"
#include "agw_wind_radii_area_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_WIND_RADII_AREA_OBJECT_NAME "AGW_WIND_RADII_AREA"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_wind_radii_area_object_struct
{
    // Wind radii area specific data
    AGW_WIND_RADII_AREA_DATA_STRUCT sData;

} AGW_WIND_RADII_AREA_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static SMSAPI_RETURN_CODE_ENUM eWindSpeed (
    AGW_WIND_RADII_AREA_OBJECT hAgwWindRd,
    OSAL_FIXED_OBJECT hWindSpeed
        );

static N32 n32FPrintf (
    AGW_WIND_RADII_AREA_OBJECT hAgwWindRd,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_WIND_RADII_AREA_OBJECT_INTERFACE_STRUCT AGW_WIND_RADII_AREA = {
    /* eWindSpeed = */ eWindSpeed,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _AGW_WIND_RADII_AREA_OBJ_H_ */
