/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_TILE_OBJ_H_
#define _AGW_TILE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "srm_obj.h"
#include "sms_update.h"
#include "dataservice_mgr_obj.h"
#include "dataservice_base.h"
#include "image_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_TILE_OBJECT_NAME "AGW_TILE"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_tile_object_struct
{
    // Public product type
    AGW_PRODUCT_TYPE_ENUM ePublicProductType;

    // Bounding box area
    AGW_BOUNDING_BOX_STRUCT sBoundingBox;

    // Upper corner in location object representation
    LOCATION_OBJECT hNorthWest;

    // Lower corner in location object representation
    LOCATION_OBJECT hSouthEast;

    // Full timestamp
    TIME_T tTimeStamp;

    // Corresponding image object
    IMAGE_OBJECT hImage;

} AGW_TILE_OBJECT_STRUCT;

// Specific data for the IMAGE object
typedef struct agw_tile_image_data_struct
{
    // Tile width in pixels
    UN16 un16Width;

    // Tile height in pixels 
    UN16 un16Height;

    // Tile bits-per-pixel
    UN8 un8BPP;
} AGW_TILE_IMAGE_DATA_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static AGW_PRODUCT_TYPE_ENUM eProductType (
        AGW_TILE_OBJECT hAgwTile
            );

static TIME_T tTimeStamp (
        AGW_TILE_OBJECT hAgwTile
            );

static LOCATION_OBJECT hNorthWest (
        AGW_TILE_OBJECT hAgwTile
            );

static LOCATION_OBJECT hSouthEast (
    AGW_TILE_OBJECT hAgwTile
        );

static IMAGE_OBJECT hImage(
    AGW_TILE_OBJECT hAgwTile
        );

static N32 n32FPrintf (
    AGW_TILE_OBJECT hAgwMsg,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Object Private Prototypes */
static LOCATION_OBJECT hCreateLocationObject(
    AGW_TILE_OBJECT_STRUCT *psObj,
    N16 n16Lat,
    N16 n16Lon
        );

static BOOLEAN bUpdateLocationObject(
    AGW_TILE_OBJECT_STRUCT *psObj,
    LOCATION_OBJECT *phLocation,
    N16 n16Lat,
    N16 n16Lon
        );

static BOOLEAN bUpdateTimeStamp(
    AGW_TILE_OBJECT_STRUCT *psObj,
    AGW_PRODUCT_HEADER_STRUCT *psHeader
        );

static BOOLEAN bUpdateBoundingBox(
    AGW_TILE_OBJECT_STRUCT *psObj
        );

static BOOLEAN bAgwTileImageInitSpecificData (
    IMAGE_OBJECT hImage,
    void *pvSpecificData,
    void *pvArg
        );

static void vAgwTileImageUninitSpecificData (
    IMAGE_OBJECT hImage,
    void *pvSpecificData
        );

static SMSAPI_RETURN_CODE_ENUM eAgwTileImageProperty (
    IMAGE_OBJECT hImage,
    IMAGE_PROPERTY_INTERNAL_ENUM eProperty,
    void *pvSpecificData,
    IMAGE_PROPERTY_INTERNAL_VALUE_STRUCT *psValue
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_TILE_OBJECT_INTERFACE_STRUCT AGW_TILE = {
    /* eProductType = */ eProductType,
    /* tTimeStamp = */ tTimeStamp,
    /* hNorthWest = */ hNorthWest,
    /* hSouthEast = */ hSouthEast,
    /* hImage = */ hImage,
    /* n32FPrintf = */ n32FPrintf
};

// IMAGE object specific interface implementation
static const IMAGE_INTF_STRUCT GsAgwTileImageIntf =
{
    /*.tSpecificDataSize = */ sizeof(AGW_TILE_IMAGE_DATA_STRUCT),
    /*.bInitSpecificData = */ bAgwTileImageInitSpecificData,
    /*.bCreationPostStep = */ NULL,
    /*.vUninitSpecificData = */ vAgwTileImageUninitSpecificData,
    /*.bCalculateImageFileNameLen = */ AGW_MGR_bGetTileFilePathLen,
    /*.bCreateImageFileName = */ AGW_MGR_bCreateTileFilePath,
    /*.eProperty = */ eAgwTileImageProperty,
    /*.eUpdateProperty = */ NULL
};

/**********************/
/** INLINE FUNCTIONS **/
/**********************/
#endif  // _AGW_TILE_OBJ_H_
