/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_STORM_OBJ_H_
#define _AGW_STORM_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"
#include "sms_obj.h"
#include "string_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_STORM_OBJECT_NAME "AGW_STORM"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_storm_object_struct
{
    // Storm ID
    STRING_OBJECT hStormID;

    // Storm Name
    STRING_OBJECT hStormName;

    // Storm Position list (AGW_STORM_POSITION_DESC_STRUCT)
    OSAL_OBJECT_HDL hPositionList;
} AGW_STORM_OBJECT_STRUCT;

// Positions iteration callback
typedef struct agw_storm_position_iterate_shim_arg_struct
{
    // Callback function
    AGW_SHAPE_CALLBACK bIteratorCallback;

    // Callback arg
    void *pvIteratorCallback;
} AGW_STORM_POSITION_ITERATE_SHIM_ARG_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static N16 n16StormPositionSort(
    AGW_STORM_POSITION_OBJECT hStPos1,
    AGW_STORM_POSITION_OBJECT hStPos2
        );

static BOOLEAN bIteratePositionShim(
    void *pvData,
    void *pvArg
        );

static void vDestroyObject(
    AGW_STORM_OBJECT_STRUCT *psObj
        );

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _AGW_STORM_OBJ_H_ */
