/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_STORM_ATTRIBUTES_OBJ_H_
#define _AGW_STORM_ATTRIBUTES_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"
#include "sms_api.h"
#include "string_obj.h"
#include "agw_mgr_obj.h"
#include "agw_storm_attributes_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_STORM_ATTRIBUTES_OBJECT_NAME "AGW_STORM_ATTRIBUTES"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_storm_attributes_object_struct
{
    AGW_STORM_ATTRIBUTES_DATA_STRUCT sData;
} AGW_STORM_ATTRIBUTES_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static STRING_OBJECT hStormID (
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

static TIME_T tObservationTime (
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

static SMSAPI_RETURN_CODE_ENUM eEchoTop (
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr,
    OSAL_FIXED_OBJECT hEchoTop
        );

static SMSAPI_RETURN_CODE_ENUM eDirection(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr,
    OSAL_FIXED_OBJECT hDirection
        );

static SMSAPI_RETURN_CODE_ENUM eSpeed(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr,
    OSAL_FIXED_OBJECT hSpeed
        );

static BOOLEAN bIsHailProbable(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

static BOOLEAN bIsHailPositive(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

static BOOLEAN bIsMesocyclonic(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

static BOOLEAN bIsTornadic(
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr
        );

static N32 n32FPrintf (
    AGW_STORM_ATTRIBUTES_OBJECT hAgwStormAttr,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Object Private Prototypes */

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_STORM_ATTRIBUTES_OBJECT_INTERFACE_STRUCT AGW_STORM_ATTRIBUTES = {
    /* hStormID = */ hStormID,
    /* tObservationTime = */ tObservationTime,
    /* un32EchoTop = */ eEchoTop,
    /* eDirection = */ eDirection,
    /* eSpeed = */ eSpeed,
    /* bIsHailProbable = */ bIsHailProbable,
    /* bIsHailPositive = */ bIsHailPositive,
    /* bIsMesocyclonic = */ bIsMesocyclonic,
    /* bIsTornadic = */ bIsTornadic,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif /* _AGW_STORM_ATTRIBUTES_OBJ_H_ */
