/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_SHAPE_OBJ_H_
#define _AGW_SHAPE_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_SHAPE_OBJECT_NAME "AGW_SHAPE"

/* Object name prefix for objects */
#define AGW_SHAPE_PREFIX "AS"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_shape_borders_struct
{
    OSAL_FIXED_OBJECT hNorth;
    OSAL_FIXED_OBJECT hEast;
    OSAL_FIXED_OBJECT hSouth;
    OSAL_FIXED_OBJECT hWest;
    BOOLEAN bIsValid;
} AGW_SHAPE_BORDERS_STRUCT;

typedef struct agw_shape_points_desc_struct
{
    // Keeps the Bounding Box
    AGW_BOUNDING_BOX_STRUCT sBB;

    // Keeps sign of the closed shape (polygon)
    BOOLEAN bIsClosed;

    // Borders capacitor
    AGW_SHAPE_BORDERS_STRUCT sBorders;

} AGW_SHAPE_POINTS_DESC_STRUCT;

typedef struct agw_shape_object_struct
{
    // Product type
    AGW_PRODUCT_TYPE_ENUM eProductType;

    // Shape type
    AGW_SHAPE_TYPE_ENUM eType;

    // Timestamp
    TIME_T tTimeStamp;

    // Number of points
    UN16 un16Points;

    AGW_SHAPE_POINTS_DESC_STRUCT *psPointsDesc;

    // Points array
    AGW_GEO_POINT_STRUCT *pasPoints;

    // The RAW buffer for points and bounding box
    void *pvData;

    // Callback interface
    const AGW_SHAPE_CALLBACK_INTERFACE_STRUCT *psIntf;

} AGW_SHAPE_OBJECT_STRUCT;

// Location crossing iterators argument
typedef struct agw_shape_location_cross_arg_struct
{
    // Location to check
    LOCATION_OBJECT hLocation;

    // Lines crossing check
    BOOLEAN bCross;

    // Number of crossing rays
    UN8 un8NumOfRayCrossings;
} AGW_SHAPE_LOCATION_CROSS_ARG_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static AGW_PRODUCT_TYPE_ENUM eProductType (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_SHAPE_TYPE_ENUM eShapeType (
    AGW_SHAPE_OBJECT hAgwShape
        );

static TIME_T tTimeStamp (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_FRONT_OBJECT hFront (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_ISOBAR_OBJECT hIsobar (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_PRESSURE_CENTER_OBJECT hPressureCenter (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_STORM_ATTRIBUTES_OBJECT hStormAttributes (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_STORM_POSITION_OBJECT hStormPosition (
    AGW_SHAPE_OBJECT hAgwShape
        );

static AGW_WIND_RADII_AREA_OBJECT hWindRadiiArea (
    AGW_SHAPE_OBJECT hAgwShape
        );

static UN16 un16Points (
	AGW_SHAPE_OBJECT hAgwShape
        );

static SMSAPI_RETURN_CODE_ENUM eIteratePoints (
	AGW_SHAPE_OBJECT hAgwShape,
    AGW_SHAPE_POINTS_ITERATOR_CALLBACK bCallback,
    void *pvCallbackArg
        );

static SMSAPI_RETURN_CODE_ENUM eGetPoint (
	AGW_SHAPE_OBJECT hAgwShape,
    OSAL_FIXED_OBJECT hLat,
    OSAL_FIXED_OBJECT hLon,
    UN16 un16Point
        );

static N32 n32FPrintf (
    AGW_SHAPE_OBJECT hAgwShape,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Callback interface */
static AGW_RETURN_CODE_ENUM eDefaultHasIntersection (
    AGW_SHAPE_OBJECT hShape,
    const AGW_LOCATION_DESC_STRUCT *psLocDesc
        );

/* Object Private Prototypes */
static BOOLEAN bUpdateBordersBox(
    AGW_SHAPE_BORDERS_STRUCT *psBorders,
    AGW_GEO_POINT_STRUCT *psPoint
        );

static BOOLEAN bUpdateBoundingBox(
    AGW_SHAPE_OBJECT_STRUCT *psObj
        );

static AGW_GEO_POINT_STRUCT *psGeoPointCreateInMemory (
    N32 n32Lat,
    N32 n32Lon,
    AGW_GEO_POINT_STRUCT *psGeoPoint,
    UN8 un8PowOfDivider
        );

static void vPointsArrayDestroy (
	AGW_SHAPE_OBJECT_STRUCT *psObj
        );

static BOOLEAN bPointsArrayCreate (
    AGW_SHAPE_OBJECT_STRUCT *psObj
        );

static N32 n32GeoPointFPrintf (
    AGW_GEO_POINT_STRUCT *psObj,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutput
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_SHAPE_OBJECT_INTERFACE_STRUCT AGW_SHAPE = {
    /* eProductType = */ eProductType,
    /* eShapeType = */ eShapeType,
    /* tTimeStamp = */ tTimeStamp,
    /* hFront = */ hFront,
    /* hIsobar = */ hIsobar,
    /* hPressureCenter = */ hPressureCenter,
    /* hStormAttributes = */ hStormAttributes,
    /* hStormPosition = */ hStormPosition,
    /* hWindRadiiArea = */ hWindRadiiArea,
    /* un16Points = */ un16Points,
    /* eIteratePoints = */ eIteratePoints,
    /* eGetPoint = */ eGetPoint,
    /* n32FPrintf = */ n32FPrintf
};

// Default interface
const AGW_SHAPE_CALLBACK_INTERFACE_STRUCT GsShapeDefaultIntf = {
    /* eHasIntersection = */ eDefaultHasIntersection
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _AGW_SHAPE_OBJ_H_
