/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_PRESSURE_CENTER_OBJ_H_
#define _AGW_PRESSURE_CENTER_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "srm_obj.h"
#include "sms_update.h"
#include "dataservice_mgr_obj.h"
#include "dataservice_base.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_PRESSURE_CENTER_OBJECT_NAME "AGW_PRESSURE_CENTER"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_pressure_center_object_struct
{
	// Type
	AGW_PRESSURE_TYPE_ENUM eType;

	// Pressure value
	AGW_FIXED_OBJECT_STRUCT sPressure;
} AGW_PRESSURE_CENTER_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static AGW_PRESSURE_TYPE_ENUM eType (
    AGW_PRESSURE_CENTER_OBJECT hAgwPressCntr
        );

static SMSAPI_RETURN_CODE_ENUM ePressure (
    AGW_PRESSURE_CENTER_OBJECT hAgwPressCntr,
    OSAL_FIXED_OBJECT hPressure
        );

static N32 n32FPrintf (
    AGW_PRESSURE_CENTER_OBJECT hAgwPressCntr,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

/* Object Private Prototypes */

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_PRESSURE_CENTER_OBJECT_INTERFACE_STRUCT AGW_PRESSURE_CENTER = {
	/* eType = */ eType,
	/* ePressure = */ ePressure,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _AGW_PRESSURE_CENTER_OBJ_H_
